(*^
::[	Information =

	"This is a Mathematica Notebook file.  It contains ASCII text, and can be
	transferred by email, ftp, or other text-file transfer utility.  It should
	be read or edited using a copy of Mathematica or MathReader.  If you 
	received this as email, use your mail application or copy/paste to save 
	everything from the line containing (*^ down to the line containing ^*)
	into a plain text file.  On some systems you may have to give the file a 
	name ending with ".ma" to allow Mathematica to recognize it as a Notebook.
	The line below identifies what version of Mathematica created this file,
	but it can be opened using any other version as well.";

	FrontEndVersion = "Macintosh Mathematica Notebook Front End Version 2.2";

	MacintoshStandardFontEncoding; 
	
	fontset = title, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, bold, e8,  24, "Times"; 
	fontset = subtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, bold, e6,  18, "Times"; 
	fontset = subsubtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, italic, e6,  14, "Times"; 
	fontset = section, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, grayBox, M22, bold, a20,  18, "Times"; 
	fontset = subsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, blackBox, M19, bold, a15,  14, "Times"; 
	fontset = subsubsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, whiteBox, M18, bold, R65535, a12,  12, "Times"; 
	fontset = text, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = smalltext, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  10, "Times"; 
	fontset = input, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeInput, M42, N23, bold, L-5,  10, "Courier"; 
	fontset = output, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, L-5,  10, "Courier"; 
	fontset = message, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, R65535, L-5,  12, "Courier"; 
	fontset = print, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, L-5,  10, "Courier"; 
	fontset = info, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, B65535, L-5,  12, "Courier"; 
	fontset = postscript, PostScript, formatAsPostScript, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeGraphics, M7, l34, w282, h287,  12, "Courier"; 
	fontset = name, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, italic,  10, "Geneva"; 
	fontset = header, inactive, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = leftheader, inactive, L2,  12, "Times"; 
	fontset = footer, inactive, noKeepOnOnePage, preserveAspect, center, M7,  12, "Times"; 
	fontset = leftfooter, inactive, L2,  12, "Times"; 
	fontset = help, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  10, "Times"; 
	fontset = clipboard, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = completions, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special1, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special2, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special3, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special4, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special5, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	paletteColors = 128; automaticGrouping; currentKernel; 
]
:[font = title; inactive; locked; preserveAspect; startGroup]
Shor's Quantum Algorithm for Factoring Composite Integers
:[font = subsubtitle; inactive; locked; preserveAspect]
Colin P. Williams
:[font = input; initialization; preserveAspect]
*)
Off[General::spell1]
(*
:[font = section; inactive; locked; preserveAspect; startGroup]
Copyright Notice
:[font = text; inactive; locked; preserveAspect; endGroup]
Copyright Colin P. Williams (1997).

This Notebook is intended to be used in conjunction with "Explorations in Quantum Computing" by Colin P. Williams and Scott H. Clearwater, TELOS, Springer-Verlag (1997), ISBN:0-387-94768-X. Permission is hereby granted to copy and distribute this Notebook freely for any non-commercial activity provided you include this copyright notice at the beginning of all such copies. Please send suggestions and bug reports to Colin P. Williams at 
        colin@solstice.jpl.nasa.gov      (818) 306 6512 or 
        cpw@cs.stanford.edu               (415) 728 2118
For information on "Explorations in Quantum Computing" check out the TELOS web site:  http://www.telospub.com/catalog/PHYSICS/Explorations.html. To order call 1-800-777-4643.

All other rights reserved.
:[font = section; inactive; locked; preserveAspect; startGroup]
How to use this Notebook
:[font = text; inactive; locked; preserveAspect]
This Notebook contains code for simulating the steps taken by a quantum computer following Peter Shor's algorithm for factoring integers. See "Explorations in Quantum Computing", Chapter 6.

To run the simulator use the command "RunShorsAlgorithm". For example, 
:[font = input; locked; preserveAspect]
RunShorsAlgorithm[15]
:[font = text; inactive; locked; preserveAspect]
will simulate an attempt to factor 15. This command may take two options:
:[font = input; locked; preserveAspect]
RunShorsAlgorithm[15, Period->QuantumMethod]
RunShorsAlgorithm[15, Period->ClassicalMethod]
:[font = text; inactive; locked; preserveAspect; endGroup]
which controls whether the determination of the period is done using the classical or quantum method. The ClassicalMethod option is merely intended as a way of checking that the quantum algorithm returns the correct factors.  Note that Shor's algorithm is non-deterministic and is not guaranteed to succeed every time. However, just a few repeats are usually enough to determine non-trivial factors. For more details, see Chapter 6.

The simulation is very slow due to the need to operate upon exponentially large data structures that represent the mathematical description of the contents of a quantum memory register. An actual quantum computer would be vastly more efficient at running Shor's algorithm by exploiting the Principle of Superposition to represent the contents of the quantum register directly in a single physical state. Indeed, if anyone COULD ever simulate Shor's algorithm efficiently on a classical computer, this in itself would lead to a fast method for factoring integers.

In the output from the simulator you will see the state of certain registers written in the form:
a0 ket[0] + a1 ket[1] + ... <<238>> ... + a242 ket[242]
The <<238>> notation is a just shorthand for saying "plus 238 similar terms". To print the entire mathematical description of the state of the register would be rather messy.
:[font = section; inactive; preserveAspect; startGroup]
Shor's Quantum Algorithm for Factoring an Integer
:[font = text; inactive; preserveAspect]
To remind yourself how to run the simulator enter ?RunShorsAlgorithm:
:[font = input; preserveAspect; startGroup]
?RunShorsAlgorithm
:[font = print; inactive; preserveAspect; endGroup]
RunShorsAlgorithm[n] creates a simulation of how a quantum computer would find the
   factors of n using Peter Shor's quantum factoring algorithm. You can give
   RunShorsAlgorithm various options that control the output from the simulator. The
   period of x^a mod n can be calculated in one of two ways. If you set
   Period->QuantumMethod (the default) then RunShorsAlgorithm performs a faithful
   quantum simulation of the steps a quantum computer would take to compute the
   period of x^a mod n. This can be slow because of the need to compute a discrete
   Fourier transform. If you are only interested in seeing what factors a quantum
   computer would have found (not how it did it) then you can set
   Period->ClassicalMethod. This returns the same result as the quantum simulation
   but computes the period in a classical way.
:[font = subsubsection; inactive; preserveAspect; startGroup]
Try me!
:[font = input; preserveAspect; startGroup]
RunShorsAlgorithm[15]
:[font = print; inactive; preserveAspect]
Step 1: Picking a random integer x, 1 < x < 15, that is co-prime to 15.
>> Picked x == 7.


Step 2: Picking a "smooth" q, i.e. an integer of order O(n^2) ~ 225
   that has small prime factors.
>> Picked q == 243.
                                 a
Step 3: Computing the period of 7  mod 15.
Repeat steps 3(a)-3(g) O(log(q)) times.

Step 3(a):
Initially, place Reg1 and Reg2 in the state |0,0>.

Step 3(b):
Loading Reg1 with a superposition of all integers in the range 0 to q-1,
   i.e. creating the superposition 1/Sqrt[q] Sum[ket[a], {a,0,q-1}
This puts Reg1 in the state:
Reg1 = 0.06415 ket[0] + 0.06415 ket[1] + 0.06415 ket[2] + 0.06415 ket[3] + 
 
   0.06415 ket[4] + 0.06415 ket[5] + 0.06415 ket[6] + 0.06415 ket[7] + 
 
   0.06415 ket[8] + 0.06415 ket[9] + 0.06415 ket[10] + 0.06415 ket[11] + 
 
   0.06415 ket[12] + 0.06415 ket[13] + 0.06415 ket[14] + 0.06415 ket[15] + 
 
   0.06415 ket[16] + <<217>> + 0.06415 ket[234] + 0.06415 ket[235] + 
 
   0.06415 ket[236] + 0.06415 ket[237] + 0.06415 ket[238] + 0.06415 ket[239] + 
 
   0.06415 ket[240] + 0.06415 ket[241] + 0.06415 ket[242]

Step 3(c):
                   a
Loading Reg2 with x  mod 15
This puts Reg2 in a state representing a superposition of the integers:
{1, 7, 4, 13, 1, 7, 4, 13  ...  13, 1, 7, 4, 13, 1, 7, 4}


Step 3(d): Measuring the state of Reg2
measureReg2 = 4
The measurement of Reg2 has a side effect on the state of Reg1.
In fact the state of Reg1 is projected into:
projectReg1 = 0.128037 ket[2] + 0.128037 ket[6] + 0.128037 ket[10] + 
 
   0.128037 ket[14] + 0.128037 ket[18] + 0.128037 ket[22] + 0.128037 ket[26] + 
 
   0.128037 ket[30] + 0.128037 ket[34] + 0.128037 ket[38] + 0.128037 ket[42] + 
 
   0.128037 ket[46] + 0.128037 ket[50] + 0.128037 ket[54] + 0.128037 ket[58] + 
 
   0.128037 ket[62] + <<37>> + 0.128037 ket[214] + 0.128037 ket[218] + 
 
   0.128037 ket[222] + 0.128037 ket[226] + 0.128037 ket[230] + 0.128037 ket[234] + 
 
   0.128037 ket[238] + 0.128037 ket[242]


Step 3(e): Computing discrete Fourier transform of the contents of Reg1.
This may take several minutes!
(Remember you are watching a classical simulation of a quantum algorithm).
The Fourier transform puts Reg1 in the state:

Fourier = 0.501028 ket[0] + (0.00205408 + 0.0000265574 I) ket[1] + 
 
   (0.00205614 + 0.0000531769 I) ket[2] + (0.00205959 + 0.0000799213 I) ket[3] + 
 
   (0.00206442 + 0.000106854 I) ket[4] + (0.00207067 + 0.000134039 I) ket[5] + 
 
   (0.00207835 + 0.000161542 I) ket[6] + (0.00208749 + 0.000189432 I) ket[7] + 
 
   (0.00209812 + 0.000217779 I) ket[8] + <<230>> + 
 
   (0.00206442 - 0.000106854 I) ket[239] + (0.00205959 - 0.0000799213 I) ket[240] + 
 
   (0.00205614 - 0.0000531769 I) ket[241] + (0.00205408 - 0.0000265574 I) ket[242]


Steps 3(f)&3(g): Sample from Fourier spectrum created in Reg1
This entails repeating the previous steps & measuring Reg1 each time.
Found samples: {ket[182], ket[0], ket[0], ket[181], ket[0], ket[121], ket[182], 
 
   ket[0], ket[182], ket[121], ket[59], ket[60]}

Step 4: Extract the period, r, from the given samples.
Each sample provides a value k
Finding the closest rational to k/q, whose denominator is less than n.
Each such rational has the form lambda/r, where r is the period.
Period was r=4

Step 5: Obtain the factors of n from the period, r.
Computing the factors of n from
GCD[x^(r/2) - 1, n] and
GCD[x^(r/2) + 1, n]
In this case, x=7, r=4, n=15
GCD[49 - 1, 15] = 3
GCD[49 + 1, 15] = 5
So the factors of n=15 are 3 and 5.
:[font = postscript; PostScript; formatAsPostScript; output; inactive; preserveAspect; pictureLeft = 34; pictureWidth = 282; pictureHeight = 174; startGroup]
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-4.25007e-17 0.00411523 0 0.0412023 [
[(50)] .20576 0 0 2 0 Minner Mrotsboxa
[(100)] .41152 0 0 2 0 Minner Mrotsboxa
[(150)] .61728 0 0 2 0 Minner Mrotsboxa
[(200)] .82305 0 0 2 0 Minner Mrotsboxa
[(Contents Reg1)] .5 0 0 2 0 0 -1 Mouter Mrotsboxa
[(0)] -0.0125 0 1 0 0 Minner Mrotsboxa
[(2)] -0.0125 .0824 1 0 0 Minner Mrotsboxa
[(4)] -0.0125 .16481 1 0 0 Minner Mrotsboxa
[(6)] -0.0125 .24721 1 0 0 Minner Mrotsboxa
[(8)] -0.0125 .32962 1 0 0 Minner Mrotsboxa
[(10)] -0.0125 .41202 1 0 0 Minner Mrotsboxa
[(12)] -0.0125 .49443 1 0 0 Minner Mrotsboxa
[(14)] -0.0125 .57683 1 0 0 Minner Mrotsboxa
[(Contents Reg2)] -0.0125 .30902 1 0 90 -1 0 Mouter Mrotsboxa
[(Initialize Reg1 & Reg2 as |0,0>)] .5 .61803 0 -2 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 .61903 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
0 0 .5 r
.001 w
.20576 0 m
.20576 .61803 L
s
P
p
0 0 .5 r
.001 w
.41152 0 m
.41152 .61803 L
s
P
p
0 0 .5 r
.001 w
.61728 0 m
.61728 .61803 L
s
P
p
0 0 .5 r
.001 w
.82305 0 m
.82305 .61803 L
s
P
p
0 0 .5 r
.001 w
0 .0824 m
1 .0824 L
s
P
p
0 0 .5 r
.001 w
0 .16481 m
1 .16481 L
s
P
p
0 0 .5 r
.001 w
0 .24721 m
1 .24721 L
s
P
p
0 0 .5 r
.001 w
0 .32962 m
1 .32962 L
s
P
p
0 0 .5 r
.001 w
0 .41202 m
1 .41202 L
s
P
p
0 0 .5 r
.001 w
0 .49443 m
1 .49443 L
s
P
p
0 0 .5 r
.001 w
0 .57683 m
1 .57683 L
s
P
p
.002 w
.20576 0 m
.20576 .00625 L
s
P
[(50)] .20576 0 0 2 0 Minner Mrotshowa
p
.002 w
.41152 0 m
.41152 .00625 L
s
P
[(100)] .41152 0 0 2 0 Minner Mrotshowa
p
.002 w
.61728 0 m
.61728 .00625 L
s
P
[(150)] .61728 0 0 2 0 Minner Mrotshowa
p
.002 w
.82305 0 m
.82305 .00625 L
s
P
[(200)] .82305 0 0 2 0 Minner Mrotshowa
p
.001 w
.04115 0 m
.04115 .00375 L
s
P
p
.001 w
.0823 0 m
.0823 .00375 L
s
P
p
.001 w
.12346 0 m
.12346 .00375 L
s
P
p
.001 w
.16461 0 m
.16461 .00375 L
s
P
p
.001 w
.24691 0 m
.24691 .00375 L
s
P
p
.001 w
.28807 0 m
.28807 .00375 L
s
P
p
.001 w
.32922 0 m
.32922 .00375 L
s
P
p
.001 w
.37037 0 m
.37037 .00375 L
s
P
p
.001 w
.45267 0 m
.45267 .00375 L
s
P
p
.001 w
.49383 0 m
.49383 .00375 L
s
P
p
.001 w
.53498 0 m
.53498 .00375 L
s
P
p
.001 w
.57613 0 m
.57613 .00375 L
s
P
p
.001 w
.65844 0 m
.65844 .00375 L
s
P
p
.001 w
.69959 0 m
.69959 .00375 L
s
P
p
.001 w
.74074 0 m
.74074 .00375 L
s
P
p
.001 w
.78189 0 m
.78189 .00375 L
s
P
p
.001 w
.8642 0 m
.8642 .00375 L
s
P
p
.001 w
.90535 0 m
.90535 .00375 L
s
P
p
.001 w
.9465 0 m
.9465 .00375 L
s
P
p
.001 w
.98765 0 m
.98765 .00375 L
s
P
[(Contents Reg1)] .5 0 0 2 0 0 -1 Mouter Mrotshowa
p
.002 w
0 0 m
1 0 L
s
P
p
.002 w
0 0 m
.00625 0 L
s
P
[(0)] -0.0125 0 1 0 0 Minner Mrotshowa
p
.002 w
0 .0824 m
.00625 .0824 L
s
P
[(2)] -0.0125 .0824 1 0 0 Minner Mrotshowa
p
.002 w
0 .16481 m
.00625 .16481 L
s
P
[(4)] -0.0125 .16481 1 0 0 Minner Mrotshowa
p
.002 w
0 .24721 m
.00625 .24721 L
s
P
[(6)] -0.0125 .24721 1 0 0 Minner Mrotshowa
p
.002 w
0 .32962 m
.00625 .32962 L
s
P
[(8)] -0.0125 .32962 1 0 0 Minner Mrotshowa
p
.002 w
0 .41202 m
.00625 .41202 L
s
P
[(10)] -0.0125 .41202 1 0 0 Minner Mrotshowa
p
.002 w
0 .49443 m
.00625 .49443 L
s
P
[(12)] -0.0125 .49443 1 0 0 Minner Mrotshowa
p
.002 w
0 .57683 m
.00625 .57683 L
s
P
[(14)] -0.0125 .57683 1 0 0 Minner Mrotshowa
p
.001 w
0 .01648 m
.00375 .01648 L
s
P
p
.001 w
0 .03296 m
.00375 .03296 L
s
P
p
.001 w
0 .04944 m
.00375 .04944 L
s
P
p
.001 w
0 .06592 m
.00375 .06592 L
s
P
p
.001 w
0 .09889 m
.00375 .09889 L
s
P
p
.001 w
0 .11537 m
.00375 .11537 L
s
P
p
.001 w
0 .13185 m
.00375 .13185 L
s
P
p
.001 w
0 .14833 m
.00375 .14833 L
s
P
p
.001 w
0 .18129 m
.00375 .18129 L
s
P
p
.001 w
0 .19777 m
.00375 .19777 L
s
P
p
.001 w
0 .21425 m
.00375 .21425 L
s
P
p
.001 w
0 .23073 m
.00375 .23073 L
s
P
p
.001 w
0 .26369 m
.00375 .26369 L
s
P
p
.001 w
0 .28018 m
.00375 .28018 L
s
P
p
.001 w
0 .29666 m
.00375 .29666 L
s
P
p
.001 w
0 .31314 m
.00375 .31314 L
s
P
p
.001 w
0 .3461 m
.00375 .3461 L
s
P
p
.001 w
0 .36258 m
.00375 .36258 L
s
P
p
.001 w
0 .37906 m
.00375 .37906 L
s
P
p
.001 w
0 .39554 m
.00375 .39554 L
s
P
p
.001 w
0 .4285 m
.00375 .4285 L
s
P
p
.001 w
0 .44498 m
.00375 .44498 L
s
P
p
.001 w
0 .46147 m
.00375 .46147 L
s
P
p
.001 w
0 .47795 m
.00375 .47795 L
s
P
p
.001 w
0 .51091 m
.00375 .51091 L
s
P
p
.001 w
0 .52739 m
.00375 .52739 L
s
P
p
.001 w
0 .54387 m
.00375 .54387 L
s
P
p
.001 w
0 .56035 m
.00375 .56035 L
s
P
p
.001 w
0 .59331 m
.00375 .59331 L
s
P
p
.001 w
0 .60979 m
.00375 .60979 L
s
P
[(Contents Reg2)] -0.0125 .30902 1 0 90 -1 0 Mouter Mrotshowa
p
.002 w
0 0 m
0 .61803 L
s
P
P
p
p
.002 w
0 .61178 m
0 .61803 L
s
P
p
.002 w
.20576 .61178 m
.20576 .61803 L
s
P
p
.002 w
.41152 .61178 m
.41152 .61803 L
s
P
p
.002 w
.61728 .61178 m
.61728 .61803 L
s
P
p
.002 w
.82305 .61178 m
.82305 .61803 L
s
P
p
.001 w
.04115 .61428 m
.04115 .61803 L
s
P
p
.001 w
.0823 .61428 m
.0823 .61803 L
s
P
p
.001 w
.12346 .61428 m
.12346 .61803 L
s
P
p
.001 w
.16461 .61428 m
.16461 .61803 L
s
P
p
.001 w
.24691 .61428 m
.24691 .61803 L
s
P
p
.001 w
.28807 .61428 m
.28807 .61803 L
s
P
p
.001 w
.32922 .61428 m
.32922 .61803 L
s
P
p
.001 w
.37037 .61428 m
.37037 .61803 L
s
P
p
.001 w
.45267 .61428 m
.45267 .61803 L
s
P
p
.001 w
.49383 .61428 m
.49383 .61803 L
s
P
p
.001 w
.53498 .61428 m
.53498 .61803 L
s
P
p
.001 w
.57613 .61428 m
.57613 .61803 L
s
P
p
.001 w
.65844 .61428 m
.65844 .61803 L
s
P
p
.001 w
.69959 .61428 m
.69959 .61803 L
s
P
p
.001 w
.74074 .61428 m
.74074 .61803 L
s
P
p
.001 w
.78189 .61428 m
.78189 .61803 L
s
P
p
.001 w
.8642 .61428 m
.8642 .61803 L
s
P
p
.001 w
.90535 .61428 m
.90535 .61803 L
s
P
p
.001 w
.9465 .61428 m
.9465 .61803 L
s
P
p
.001 w
.98765 .61428 m
.98765 .61803 L
s
P
p
.002 w
0 .61803 m
1 .61803 L
s
P
[(Initialize Reg1 & Reg2 as |0,0>)] .5 .61803 0 -2 Mshowa
p
.002 w
.99375 0 m
1 0 L
s
P
p
.002 w
.99375 .0824 m
1 .0824 L
s
P
p
.002 w
.99375 .16481 m
1 .16481 L
s
P
p
.002 w
.99375 .24721 m
1 .24721 L
s
P
p
.002 w
.99375 .32962 m
1 .32962 L
s
P
p
.002 w
.99375 .41202 m
1 .41202 L
s
P
p
.002 w
.99375 .49443 m
1 .49443 L
s
P
p
.002 w
.99375 .57683 m
1 .57683 L
s
P
p
.001 w
.99625 .01648 m
1 .01648 L
s
P
p
.001 w
.99625 .03296 m
1 .03296 L
s
P
p
.001 w
.99625 .04944 m
1 .04944 L
s
P
p
.001 w
.99625 .06592 m
1 .06592 L
s
P
p
.001 w
.99625 .09889 m
1 .09889 L
s
P
p
.001 w
.99625 .11537 m
1 .11537 L
s
P
p
.001 w
.99625 .13185 m
1 .13185 L
s
P
p
.001 w
.99625 .14833 m
1 .14833 L
s
P
p
.001 w
.99625 .18129 m
1 .18129 L
s
P
p
.001 w
.99625 .19777 m
1 .19777 L
s
P
p
.001 w
.99625 .21425 m
1 .21425 L
s
P
p
.001 w
.99625 .23073 m
1 .23073 L
s
P
p
.001 w
.99625 .26369 m
1 .26369 L
s
P
p
.001 w
.99625 .28018 m
1 .28018 L
s
P
p
.001 w
.99625 .29666 m
1 .29666 L
s
P
p
.001 w
.99625 .31314 m
1 .31314 L
s
P
p
.001 w
.99625 .3461 m
1 .3461 L
s
P
p
.001 w
.99625 .36258 m
1 .36258 L
s
P
p
.001 w
.99625 .37906 m
1 .37906 L
s
P
p
.001 w
.99625 .39554 m
1 .39554 L
s
P
p
.001 w
.99625 .4285 m
1 .4285 L
s
P
p
.001 w
.99625 .44498 m
1 .44498 L
s
P
p
.001 w
.99625 .46147 m
1 .46147 L
s
P
p
.001 w
.99625 .47795 m
1 .47795 L
s
P
p
.001 w
.99625 .51091 m
1 .51091 L
s
P
p
.001 w
.99625 .52739 m
1 .52739 L
s
P
p
.001 w
.99625 .54387 m
1 .54387 L
s
P
p
.001 w
.99625 .56035 m
1 .56035 L
s
P
p
.001 w
.99625 .59331 m
1 .59331 L
s
P
p
.001 w
.99625 .60979 m
1 .60979 L
s
P
p
.002 w
1 0 m
1 .61803 L
s
P
P
p
P
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
p
p
.035 w
0 0 Mdot
P
P
% End of Graphics
MathPictureEnd

:[font = postscript; PostScript; formatAsPostScript; output; inactive; preserveAspect; pictureLeft = 34; pictureWidth = 282; pictureHeight = 174]
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-4.25007e-17 0.00411523 0 0.0412023 [
[(50)] .20576 0 0 2 0 Minner Mrotsboxa
[(100)] .41152 0 0 2 0 Minner Mrotsboxa
[(150)] .61728 0 0 2 0 Minner Mrotsboxa
[(200)] .82305 0 0 2 0 Minner Mrotsboxa
[(Contents of Reg1)] .5 0 0 2 0 0 -1 Mouter Mrotsboxa
[(0)] -0.0125 0 1 0 0 Minner Mrotsboxa
[(2)] -0.0125 .0824 1 0 0 Minner Mrotsboxa
[(4)] -0.0125 .16481 1 0 0 Minner Mrotsboxa
[(6)] -0.0125 .24721 1 0 0 Minner Mrotsboxa
[(8)] -0.0125 .32962 1 0 0 Minner Mrotsboxa
[(10)] -0.0125 .41202 1 0 0 Minner Mrotsboxa
[(12)] -0.0125 .49443 1 0 0 Minner Mrotsboxa
[(14)] -0.0125 .57683 1 0 0 Minner Mrotsboxa
[(Contents of Reg2)] -0.0125 .30902 1 0 90 -1 0 Mouter Mrotsboxa
[(Load Reg1 with 1/Sqrt[q] Sum[|a,0>, {a,0,q-1}])] .5 .61803 0 -2 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 .61903 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
0 0 .5 r
.001 w
.20576 0 m
.20576 .61803 L
s
P
p
0 0 .5 r
.001 w
.41152 0 m
.41152 .61803 L
s
P
p
0 0 .5 r
.001 w
.61728 0 m
.61728 .61803 L
s
P
p
0 0 .5 r
.001 w
.82305 0 m
.82305 .61803 L
s
P
p
0 0 .5 r
.001 w
0 .0824 m
1 .0824 L
s
P
p
0 0 .5 r
.001 w
0 .16481 m
1 .16481 L
s
P
p
0 0 .5 r
.001 w
0 .24721 m
1 .24721 L
s
P
p
0 0 .5 r
.001 w
0 .32962 m
1 .32962 L
s
P
p
0 0 .5 r
.001 w
0 .41202 m
1 .41202 L
s
P
p
0 0 .5 r
.001 w
0 .49443 m
1 .49443 L
s
P
p
0 0 .5 r
.001 w
0 .57683 m
1 .57683 L
s
P
p
.002 w
.20576 0 m
.20576 .00625 L
s
P
[(50)] .20576 0 0 2 0 Minner Mrotshowa
p
.002 w
.41152 0 m
.41152 .00625 L
s
P
[(100)] .41152 0 0 2 0 Minner Mrotshowa
p
.002 w
.61728 0 m
.61728 .00625 L
s
P
[(150)] .61728 0 0 2 0 Minner Mrotshowa
p
.002 w
.82305 0 m
.82305 .00625 L
s
P
[(200)] .82305 0 0 2 0 Minner Mrotshowa
p
.001 w
.04115 0 m
.04115 .00375 L
s
P
p
.001 w
.0823 0 m
.0823 .00375 L
s
P
p
.001 w
.12346 0 m
.12346 .00375 L
s
P
p
.001 w
.16461 0 m
.16461 .00375 L
s
P
p
.001 w
.24691 0 m
.24691 .00375 L
s
P
p
.001 w
.28807 0 m
.28807 .00375 L
s
P
p
.001 w
.32922 0 m
.32922 .00375 L
s
P
p
.001 w
.37037 0 m
.37037 .00375 L
s
P
p
.001 w
.45267 0 m
.45267 .00375 L
s
P
p
.001 w
.49383 0 m
.49383 .00375 L
s
P
p
.001 w
.53498 0 m
.53498 .00375 L
s
P
p
.001 w
.57613 0 m
.57613 .00375 L
s
P
p
.001 w
.65844 0 m
.65844 .00375 L
s
P
p
.001 w
.69959 0 m
.69959 .00375 L
s
P
p
.001 w
.74074 0 m
.74074 .00375 L
s
P
p
.001 w
.78189 0 m
.78189 .00375 L
s
P
p
.001 w
.8642 0 m
.8642 .00375 L
s
P
p
.001 w
.90535 0 m
.90535 .00375 L
s
P
p
.001 w
.9465 0 m
.9465 .00375 L
s
P
p
.001 w
.98765 0 m
.98765 .00375 L
s
P
[(Contents of Reg1)] .5 0 0 2 0 0 -1 Mouter Mrotshowa
p
.002 w
0 0 m
1 0 L
s
P
p
.002 w
0 0 m
.00625 0 L
s
P
[(0)] -0.0125 0 1 0 0 Minner Mrotshowa
p
.002 w
0 .0824 m
.00625 .0824 L
s
P
[(2)] -0.0125 .0824 1 0 0 Minner Mrotshowa
p
.002 w
0 .16481 m
.00625 .16481 L
s
P
[(4)] -0.0125 .16481 1 0 0 Minner Mrotshowa
p
.002 w
0 .24721 m
.00625 .24721 L
s
P
[(6)] -0.0125 .24721 1 0 0 Minner Mrotshowa
p
.002 w
0 .32962 m
.00625 .32962 L
s
P
[(8)] -0.0125 .32962 1 0 0 Minner Mrotshowa
p
.002 w
0 .41202 m
.00625 .41202 L
s
P
[(10)] -0.0125 .41202 1 0 0 Minner Mrotshowa
p
.002 w
0 .49443 m
.00625 .49443 L
s
P
[(12)] -0.0125 .49443 1 0 0 Minner Mrotshowa
p
.002 w
0 .57683 m
.00625 .57683 L
s
P
[(14)] -0.0125 .57683 1 0 0 Minner Mrotshowa
p
.001 w
0 .01648 m
.00375 .01648 L
s
P
p
.001 w
0 .03296 m
.00375 .03296 L
s
P
p
.001 w
0 .04944 m
.00375 .04944 L
s
P
p
.001 w
0 .06592 m
.00375 .06592 L
s
P
p
.001 w
0 .09889 m
.00375 .09889 L
s
P
p
.001 w
0 .11537 m
.00375 .11537 L
s
P
p
.001 w
0 .13185 m
.00375 .13185 L
s
P
p
.001 w
0 .14833 m
.00375 .14833 L
s
P
p
.001 w
0 .18129 m
.00375 .18129 L
s
P
p
.001 w
0 .19777 m
.00375 .19777 L
s
P
p
.001 w
0 .21425 m
.00375 .21425 L
s
P
p
.001 w
0 .23073 m
.00375 .23073 L
s
P
p
.001 w
0 .26369 m
.00375 .26369 L
s
P
p
.001 w
0 .28018 m
.00375 .28018 L
s
P
p
.001 w
0 .29666 m
.00375 .29666 L
s
P
p
.001 w
0 .31314 m
.00375 .31314 L
s
P
p
.001 w
0 .3461 m
.00375 .3461 L
s
P
p
.001 w
0 .36258 m
.00375 .36258 L
s
P
p
.001 w
0 .37906 m
.00375 .37906 L
s
P
p
.001 w
0 .39554 m
.00375 .39554 L
s
P
p
.001 w
0 .4285 m
.00375 .4285 L
s
P
p
.001 w
0 .44498 m
.00375 .44498 L
s
P
p
.001 w
0 .46147 m
.00375 .46147 L
s
P
p
.001 w
0 .47795 m
.00375 .47795 L
s
P
p
.001 w
0 .51091 m
.00375 .51091 L
s
P
p
.001 w
0 .52739 m
.00375 .52739 L
s
P
p
.001 w
0 .54387 m
.00375 .54387 L
s
P
p
.001 w
0 .56035 m
.00375 .56035 L
s
P
p
.001 w
0 .59331 m
.00375 .59331 L
s
P
p
.001 w
0 .60979 m
.00375 .60979 L
s
P
[(Contents of Reg2)] -0.0125 .30902 1 0 90 -1 0 Mouter Mrotshowa
p
.002 w
0 0 m
0 .61803 L
s
P
P
p
p
.002 w
0 .61178 m
0 .61803 L
s
P
p
.002 w
.20576 .61178 m
.20576 .61803 L
s
P
p
.002 w
.41152 .61178 m
.41152 .61803 L
s
P
p
.002 w
.61728 .61178 m
.61728 .61803 L
s
P
p
.002 w
.82305 .61178 m
.82305 .61803 L
s
P
p
.001 w
.04115 .61428 m
.04115 .61803 L
s
P
p
.001 w
.0823 .61428 m
.0823 .61803 L
s
P
p
.001 w
.12346 .61428 m
.12346 .61803 L
s
P
p
.001 w
.16461 .61428 m
.16461 .61803 L
s
P
p
.001 w
.24691 .61428 m
.24691 .61803 L
s
P
p
.001 w
.28807 .61428 m
.28807 .61803 L
s
P
p
.001 w
.32922 .61428 m
.32922 .61803 L
s
P
p
.001 w
.37037 .61428 m
.37037 .61803 L
s
P
p
.001 w
.45267 .61428 m
.45267 .61803 L
s
P
p
.001 w
.49383 .61428 m
.49383 .61803 L
s
P
p
.001 w
.53498 .61428 m
.53498 .61803 L
s
P
p
.001 w
.57613 .61428 m
.57613 .61803 L
s
P
p
.001 w
.65844 .61428 m
.65844 .61803 L
s
P
p
.001 w
.69959 .61428 m
.69959 .61803 L
s
P
p
.001 w
.74074 .61428 m
.74074 .61803 L
s
P
p
.001 w
.78189 .61428 m
.78189 .61803 L
s
P
p
.001 w
.8642 .61428 m
.8642 .61803 L
s
P
p
.001 w
.90535 .61428 m
.90535 .61803 L
s
P
p
.001 w
.9465 .61428 m
.9465 .61803 L
s
P
p
.001 w
.98765 .61428 m
.98765 .61803 L
s
P
p
.002 w
0 .61803 m
1 .61803 L
s
P
[(Load Reg1 with 1/Sqrt[q] Sum[|a,0>, {a,0,q-1}])] .5 .61803 0 -2 Mshowa
p
.002 w
.99375 0 m
1 0 L
s
P
p
.002 w
.99375 .0824 m
1 .0824 L
s
P
p
.002 w
.99375 .16481 m
1 .16481 L
s
P
p
.002 w
.99375 .24721 m
1 .24721 L
s
P
p
.002 w
.99375 .32962 m
1 .32962 L
s
P
p
.002 w
.99375 .41202 m
1 .41202 L
s
P
p
.002 w
.99375 .49443 m
1 .49443 L
s
P
p
.002 w
.99375 .57683 m
1 .57683 L
s
P
p
.001 w
.99625 .01648 m
1 .01648 L
s
P
p
.001 w
.99625 .03296 m
1 .03296 L
s
P
p
.001 w
.99625 .04944 m
1 .04944 L
s
P
p
.001 w
.99625 .06592 m
1 .06592 L
s
P
p
.001 w
.99625 .09889 m
1 .09889 L
s
P
p
.001 w
.99625 .11537 m
1 .11537 L
s
P
p
.001 w
.99625 .13185 m
1 .13185 L
s
P
p
.001 w
.99625 .14833 m
1 .14833 L
s
P
p
.001 w
.99625 .18129 m
1 .18129 L
s
P
p
.001 w
.99625 .19777 m
1 .19777 L
s
P
p
.001 w
.99625 .21425 m
1 .21425 L
s
P
p
.001 w
.99625 .23073 m
1 .23073 L
s
P
p
.001 w
.99625 .26369 m
1 .26369 L
s
P
p
.001 w
.99625 .28018 m
1 .28018 L
s
P
p
.001 w
.99625 .29666 m
1 .29666 L
s
P
p
.001 w
.99625 .31314 m
1 .31314 L
s
P
p
.001 w
.99625 .3461 m
1 .3461 L
s
P
p
.001 w
.99625 .36258 m
1 .36258 L
s
P
p
.001 w
.99625 .37906 m
1 .37906 L
s
P
p
.001 w
.99625 .39554 m
1 .39554 L
s
P
p
.001 w
.99625 .4285 m
1 .4285 L
s
P
p
.001 w
.99625 .44498 m
1 .44498 L
s
P
p
.001 w
.99625 .46147 m
1 .46147 L
s
P
p
.001 w
.99625 .47795 m
1 .47795 L
s
P
p
.001 w
.99625 .51091 m
1 .51091 L
s
P
p
.001 w
.99625 .52739 m
1 .52739 L
s
P
p
.001 w
.99625 .54387 m
1 .54387 L
s
P
p
.001 w
.99625 .56035 m
1 .56035 L
s
P
p
.001 w
.99625 .59331 m
1 .59331 L
s
P
p
.001 w
.99625 .60979 m
1 .60979 L
s
P
p
.002 w
1 0 m
1 .61803 L
s
P
P
p
P
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
p
p
.02 w
0 0 Mdot
.00412 0 Mdot
.00823 0 Mdot
.01235 0 Mdot
.01646 0 Mdot
.02058 0 Mdot
.02469 0 Mdot
.02881 0 Mdot
.03292 0 Mdot
.03704 0 Mdot
.04115 0 Mdot
.04527 0 Mdot
.04938 0 Mdot
.0535 0 Mdot
.05761 0 Mdot
.06173 0 Mdot
.06584 0 Mdot
.06996 0 Mdot
.07407 0 Mdot
.07819 0 Mdot
.0823 0 Mdot
.08642 0 Mdot
.09053 0 Mdot
.09465 0 Mdot
.09877 0 Mdot
.10288 0 Mdot
.107 0 Mdot
.11111 0 Mdot
.11523 0 Mdot
.11934 0 Mdot
.12346 0 Mdot
.12757 0 Mdot
.13169 0 Mdot
.1358 0 Mdot
.13992 0 Mdot
.14403 0 Mdot
.14815 0 Mdot
.15226 0 Mdot
.15638 0 Mdot
.16049 0 Mdot
.16461 0 Mdot
.16872 0 Mdot
.17284 0 Mdot
.17695 0 Mdot
.18107 0 Mdot
.18519 0 Mdot
.1893 0 Mdot
.19342 0 Mdot
.19753 0 Mdot
.20165 0 Mdot
.20576 0 Mdot
.20988 0 Mdot
.21399 0 Mdot
.21811 0 Mdot
.22222 0 Mdot
.22634 0 Mdot
.23045 0 Mdot
.23457 0 Mdot
.23868 0 Mdot
.2428 0 Mdot
.24691 0 Mdot
.25103 0 Mdot
.25514 0 Mdot
.25926 0 Mdot
.26337 0 Mdot
.26749 0 Mdot
.2716 0 Mdot
.27572 0 Mdot
.27984 0 Mdot
.28395 0 Mdot
.28807 0 Mdot
.29218 0 Mdot
.2963 0 Mdot
.30041 0 Mdot
.30453 0 Mdot
.30864 0 Mdot
.31276 0 Mdot
.31687 0 Mdot
.32099 0 Mdot
.3251 0 Mdot
.32922 0 Mdot
.33333 0 Mdot
.33745 0 Mdot
.34156 0 Mdot
.34568 0 Mdot
.34979 0 Mdot
.35391 0 Mdot
.35802 0 Mdot
.36214 0 Mdot
.36626 0 Mdot
.37037 0 Mdot
.37449 0 Mdot
.3786 0 Mdot
.38272 0 Mdot
.38683 0 Mdot
.39095 0 Mdot
.39506 0 Mdot
.39918 0 Mdot
.40329 0 Mdot
.40741 0 Mdot
.41152 0 Mdot
.41564 0 Mdot
.41975 0 Mdot
.42387 0 Mdot
.42798 0 Mdot
.4321 0 Mdot
.43621 0 Mdot
.44033 0 Mdot
.44444 0 Mdot
.44856 0 Mdot
.45267 0 Mdot
.45679 0 Mdot
.46091 0 Mdot
.46502 0 Mdot
.46914 0 Mdot
.47325 0 Mdot
.47737 0 Mdot
.48148 0 Mdot
.4856 0 Mdot
.48971 0 Mdot
.49383 0 Mdot
.49794 0 Mdot
.50206 0 Mdot
.50617 0 Mdot
.51029 0 Mdot
.5144 0 Mdot
.51852 0 Mdot
.52263 0 Mdot
.52675 0 Mdot
.53086 0 Mdot
.53498 0 Mdot
.53909 0 Mdot
.54321 0 Mdot
.54733 0 Mdot
.55144 0 Mdot
.55556 0 Mdot
.55967 0 Mdot
.56379 0 Mdot
.5679 0 Mdot
.57202 0 Mdot
.57613 0 Mdot
.58025 0 Mdot
.58436 0 Mdot
.58848 0 Mdot
.59259 0 Mdot
.59671 0 Mdot
.60082 0 Mdot
.60494 0 Mdot
.60905 0 Mdot
.61317 0 Mdot
.61728 0 Mdot
.6214 0 Mdot
.62551 0 Mdot
.62963 0 Mdot
.63374 0 Mdot
.63786 0 Mdot
.64198 0 Mdot
.64609 0 Mdot
.65021 0 Mdot
.65432 0 Mdot
.65844 0 Mdot
.66255 0 Mdot
.66667 0 Mdot
.67078 0 Mdot
.6749 0 Mdot
.67901 0 Mdot
.68313 0 Mdot
.68724 0 Mdot
.69136 0 Mdot
.69547 0 Mdot
.69959 0 Mdot
.7037 0 Mdot
.70782 0 Mdot
.71193 0 Mdot
.71605 0 Mdot
.72016 0 Mdot
.72428 0 Mdot
.7284 0 Mdot
.73251 0 Mdot
.73663 0 Mdot
.74074 0 Mdot
.74486 0 Mdot
.74897 0 Mdot
.75309 0 Mdot
.7572 0 Mdot
.76132 0 Mdot
.76543 0 Mdot
.76955 0 Mdot
.77366 0 Mdot
.77778 0 Mdot
.78189 0 Mdot
.78601 0 Mdot
.79012 0 Mdot
.79424 0 Mdot
.79835 0 Mdot
.80247 0 Mdot
.80658 0 Mdot
.8107 0 Mdot
.81481 0 Mdot
.81893 0 Mdot
.82305 0 Mdot
.82716 0 Mdot
.83128 0 Mdot
.83539 0 Mdot
.83951 0 Mdot
.84362 0 Mdot
.84774 0 Mdot
.85185 0 Mdot
.85597 0 Mdot
.86008 0 Mdot
.8642 0 Mdot
.86831 0 Mdot
.87243 0 Mdot
.87654 0 Mdot
.88066 0 Mdot
.88477 0 Mdot
.88889 0 Mdot
.893 0 Mdot
.89712 0 Mdot
.90123 0 Mdot
.90535 0 Mdot
.90947 0 Mdot
.91358 0 Mdot
.9177 0 Mdot
.92181 0 Mdot
.92593 0 Mdot
.93004 0 Mdot
.93416 0 Mdot
.93827 0 Mdot
.94239 0 Mdot
.9465 0 Mdot
.95062 0 Mdot
.95473 0 Mdot
.95885 0 Mdot
.96296 0 Mdot
.96708 0 Mdot
.97119 0 Mdot
.97531 0 Mdot
.97942 0 Mdot
.98354 0 Mdot
.98765 0 Mdot
.99177 0 Mdot
.99588 0 Mdot
P
P
% End of Graphics
MathPictureEnd

:[font = postscript; PostScript; formatAsPostScript; output; inactive; preserveAspect; pictureLeft = 34; pictureWidth = 282; pictureHeight = 174]
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-1.38778e-17 0.0454545 0 0.0441453 [
[(5)] .22727 0 0 2 0 Minner Mrotsboxa
[(10)] .45455 0 0 2 0 Minner Mrotsboxa
[(15)] .68182 0 0 2 0 Minner Mrotsboxa
[(20)] .90909 0 0 2 0 Minner Mrotsboxa
[(Contents Reg1)] .5 0 0 2 0 0 -1 Mouter Mrotsboxa
[(0)] -0.0125 0 1 0 0 Minner Mrotsboxa
[(2)] -0.0125 .08829 1 0 0 Minner Mrotsboxa
[(4)] -0.0125 .17658 1 0 0 Minner Mrotsboxa
[(6)] -0.0125 .26487 1 0 0 Minner Mrotsboxa
[(8)] -0.0125 .35316 1 0 0 Minner Mrotsboxa
[(10)] -0.0125 .44145 1 0 0 Minner Mrotsboxa
[(12)] -0.0125 .52974 1 0 0 Minner Mrotsboxa
[(14)] -0.0125 .61803 1 0 0 Minner Mrotsboxa
[(Contents Reg2)] -0.0125 .30902 1 0 90 -1 0 Mouter Mrotsboxa
[(Put superposition x^a mod n in Reg2 )( 1/Sqrt[q] Sum[|a, x^a mod n>,{a,0,q-1}])] .5 .61803 0 -2 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 .61903 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
0 0 .5 r
.001 w
.22727 0 m
.22727 .61803 L
s
P
p
0 0 .5 r
.001 w
.45455 0 m
.45455 .61803 L
s
P
p
0 0 .5 r
.001 w
.68182 0 m
.68182 .61803 L
s
P
p
0 0 .5 r
.001 w
.90909 0 m
.90909 .61803 L
s
P
p
0 0 .5 r
.001 w
0 .08829 m
1 .08829 L
s
P
p
0 0 .5 r
.001 w
0 .17658 m
1 .17658 L
s
P
p
0 0 .5 r
.001 w
0 .26487 m
1 .26487 L
s
P
p
0 0 .5 r
.001 w
0 .35316 m
1 .35316 L
s
P
p
0 0 .5 r
.001 w
0 .44145 m
1 .44145 L
s
P
p
0 0 .5 r
.001 w
0 .52974 m
1 .52974 L
s
P
p
.002 w
.22727 0 m
.22727 .00625 L
s
P
[(5)] .22727 0 0 2 0 Minner Mrotshowa
p
.002 w
.45455 0 m
.45455 .00625 L
s
P
[(10)] .45455 0 0 2 0 Minner Mrotshowa
p
.002 w
.68182 0 m
.68182 .00625 L
s
P
[(15)] .68182 0 0 2 0 Minner Mrotshowa
p
.002 w
.90909 0 m
.90909 .00625 L
s
P
[(20)] .90909 0 0 2 0 Minner Mrotshowa
p
.001 w
.04545 0 m
.04545 .00375 L
s
P
p
.001 w
.09091 0 m
.09091 .00375 L
s
P
p
.001 w
.13636 0 m
.13636 .00375 L
s
P
p
.001 w
.18182 0 m
.18182 .00375 L
s
P
p
.001 w
.27273 0 m
.27273 .00375 L
s
P
p
.001 w
.31818 0 m
.31818 .00375 L
s
P
p
.001 w
.36364 0 m
.36364 .00375 L
s
P
p
.001 w
.40909 0 m
.40909 .00375 L
s
P
p
.001 w
.5 0 m
.5 .00375 L
s
P
p
.001 w
.54545 0 m
.54545 .00375 L
s
P
p
.001 w
.59091 0 m
.59091 .00375 L
s
P
p
.001 w
.63636 0 m
.63636 .00375 L
s
P
p
.001 w
.72727 0 m
.72727 .00375 L
s
P
p
.001 w
.77273 0 m
.77273 .00375 L
s
P
p
.001 w
.81818 0 m
.81818 .00375 L
s
P
p
.001 w
.86364 0 m
.86364 .00375 L
s
P
p
.001 w
.95455 0 m
.95455 .00375 L
s
P
[(Contents Reg1)] .5 0 0 2 0 0 -1 Mouter Mrotshowa
p
.002 w
0 0 m
1 0 L
s
P
p
.002 w
0 0 m
.00625 0 L
s
P
[(0)] -0.0125 0 1 0 0 Minner Mrotshowa
p
.002 w
0 .08829 m
.00625 .08829 L
s
P
[(2)] -0.0125 .08829 1 0 0 Minner Mrotshowa
p
.002 w
0 .17658 m
.00625 .17658 L
s
P
[(4)] -0.0125 .17658 1 0 0 Minner Mrotshowa
p
.002 w
0 .26487 m
.00625 .26487 L
s
P
[(6)] -0.0125 .26487 1 0 0 Minner Mrotshowa
p
.002 w
0 .35316 m
.00625 .35316 L
s
P
[(8)] -0.0125 .35316 1 0 0 Minner Mrotshowa
p
.002 w
0 .44145 m
.00625 .44145 L
s
P
[(10)] -0.0125 .44145 1 0 0 Minner Mrotshowa
p
.002 w
0 .52974 m
.00625 .52974 L
s
P
[(12)] -0.0125 .52974 1 0 0 Minner Mrotshowa
p
.002 w
0 .61803 m
.00625 .61803 L
s
P
[(14)] -0.0125 .61803 1 0 0 Minner Mrotshowa
p
.001 w
0 .01766 m
.00375 .01766 L
s
P
p
.001 w
0 .03532 m
.00375 .03532 L
s
P
p
.001 w
0 .05297 m
.00375 .05297 L
s
P
p
.001 w
0 .07063 m
.00375 .07063 L
s
P
p
.001 w
0 .10595 m
.00375 .10595 L
s
P
p
.001 w
0 .12361 m
.00375 .12361 L
s
P
p
.001 w
0 .14126 m
.00375 .14126 L
s
P
p
.001 w
0 .15892 m
.00375 .15892 L
s
P
p
.001 w
0 .19424 m
.00375 .19424 L
s
P
p
.001 w
0 .2119 m
.00375 .2119 L
s
P
p
.001 w
0 .22956 m
.00375 .22956 L
s
P
p
.001 w
0 .24721 m
.00375 .24721 L
s
P
p
.001 w
0 .28253 m
.00375 .28253 L
s
P
p
.001 w
0 .30019 m
.00375 .30019 L
s
P
p
.001 w
0 .31785 m
.00375 .31785 L
s
P
p
.001 w
0 .3355 m
.00375 .3355 L
s
P
p
.001 w
0 .37082 m
.00375 .37082 L
s
P
p
.001 w
0 .38848 m
.00375 .38848 L
s
P
p
.001 w
0 .40614 m
.00375 .40614 L
s
P
p
.001 w
0 .42379 m
.00375 .42379 L
s
P
p
.001 w
0 .45911 m
.00375 .45911 L
s
P
p
.001 w
0 .47677 m
.00375 .47677 L
s
P
p
.001 w
0 .49443 m
.00375 .49443 L
s
P
p
.001 w
0 .51209 m
.00375 .51209 L
s
P
p
.001 w
0 .5474 m
.00375 .5474 L
s
P
p
.001 w
0 .56506 m
.00375 .56506 L
s
P
p
.001 w
0 .58272 m
.00375 .58272 L
s
P
p
.001 w
0 .60038 m
.00375 .60038 L
s
P
[(Contents Reg2)] -0.0125 .30902 1 0 90 -1 0 Mouter Mrotshowa
p
.002 w
0 0 m
0 .61803 L
s
P
P
p
p
.002 w
0 .61178 m
0 .61803 L
s
P
p
.002 w
.22727 .61178 m
.22727 .61803 L
s
P
p
.002 w
.45455 .61178 m
.45455 .61803 L
s
P
p
.002 w
.68182 .61178 m
.68182 .61803 L
s
P
p
.002 w
.90909 .61178 m
.90909 .61803 L
s
P
p
.001 w
.04545 .61428 m
.04545 .61803 L
s
P
p
.001 w
.09091 .61428 m
.09091 .61803 L
s
P
p
.001 w
.13636 .61428 m
.13636 .61803 L
s
P
p
.001 w
.18182 .61428 m
.18182 .61803 L
s
P
p
.001 w
.27273 .61428 m
.27273 .61803 L
s
P
p
.001 w
.31818 .61428 m
.31818 .61803 L
s
P
p
.001 w
.36364 .61428 m
.36364 .61803 L
s
P
p
.001 w
.40909 .61428 m
.40909 .61803 L
s
P
p
.001 w
.5 .61428 m
.5 .61803 L
s
P
p
.001 w
.54545 .61428 m
.54545 .61803 L
s
P
p
.001 w
.59091 .61428 m
.59091 .61803 L
s
P
p
.001 w
.63636 .61428 m
.63636 .61803 L
s
P
p
.001 w
.72727 .61428 m
.72727 .61803 L
s
P
p
.001 w
.77273 .61428 m
.77273 .61803 L
s
P
p
.001 w
.81818 .61428 m
.81818 .61803 L
s
P
p
.001 w
.86364 .61428 m
.86364 .61803 L
s
P
p
.001 w
.95455 .61428 m
.95455 .61803 L
s
P
p
.002 w
0 .61803 m
1 .61803 L
s
P
[(Put superposition x^a mod n in Reg2 )( 1/Sqrt[q] Sum[|a, x^a mod n>,{a,0,q-1}])] .5 .61803 0 -2 Mshowa
p
.002 w
.99375 0 m
1 0 L
s
P
p
.002 w
.99375 .08829 m
1 .08829 L
s
P
p
.002 w
.99375 .17658 m
1 .17658 L
s
P
p
.002 w
.99375 .26487 m
1 .26487 L
s
P
p
.002 w
.99375 .35316 m
1 .35316 L
s
P
p
.002 w
.99375 .44145 m
1 .44145 L
s
P
p
.002 w
.99375 .52974 m
1 .52974 L
s
P
p
.001 w
.99625 .01766 m
1 .01766 L
s
P
p
.001 w
.99625 .03532 m
1 .03532 L
s
P
p
.001 w
.99625 .05297 m
1 .05297 L
s
P
p
.001 w
.99625 .07063 m
1 .07063 L
s
P
p
.001 w
.99625 .10595 m
1 .10595 L
s
P
p
.001 w
.99625 .12361 m
1 .12361 L
s
P
p
.001 w
.99625 .14126 m
1 .14126 L
s
P
p
.001 w
.99625 .15892 m
1 .15892 L
s
P
p
.001 w
.99625 .19424 m
1 .19424 L
s
P
p
.001 w
.99625 .2119 m
1 .2119 L
s
P
p
.001 w
.99625 .22956 m
1 .22956 L
s
P
p
.001 w
.99625 .24721 m
1 .24721 L
s
P
p
.001 w
.99625 .28253 m
1 .28253 L
s
P
p
.001 w
.99625 .30019 m
1 .30019 L
s
P
p
.001 w
.99625 .31785 m
1 .31785 L
s
P
p
.001 w
.99625 .3355 m
1 .3355 L
s
P
p
.001 w
.99625 .37082 m
1 .37082 L
s
P
p
.001 w
.99625 .38848 m
1 .38848 L
s
P
p
.001 w
.99625 .40614 m
1 .40614 L
s
P
p
.001 w
.99625 .42379 m
1 .42379 L
s
P
p
.001 w
.99625 .45911 m
1 .45911 L
s
P
p
.001 w
.99625 .47677 m
1 .47677 L
s
P
p
.001 w
.99625 .49443 m
1 .49443 L
s
P
p
.001 w
.99625 .51209 m
1 .51209 L
s
P
p
.001 w
.99625 .5474 m
1 .5474 L
s
P
p
.001 w
.99625 .56506 m
1 .56506 L
s
P
p
.001 w
.99625 .58272 m
1 .58272 L
s
P
p
.001 w
.99625 .60038 m
1 .60038 L
s
P
p
.002 w
1 0 m
1 .61803 L
s
P
P
p
P
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
p
p
[ .01 .01 ] 0 setdash
.004 w
0 .04415 m
.04545 .30902 L
.09091 .17658 L
.13636 .57389 L
.18182 .04415 L
.22727 .30902 L
.27273 .17658 L
.31818 .57389 L
.36364 .04415 L
.40909 .30902 L
.45455 .17658 L
.5 .57389 L
.54545 .04415 L
.59091 .30902 L
.63636 .17658 L
.68182 .57389 L
.72727 .04415 L
.77273 .30902 L
.81818 .17658 L
.86364 .57389 L
.90909 .04415 L
.95455 .30902 L
1 .17658 L
s
P
p
p
.02 w
0 .04415 Mdot
.04545 .30902 Mdot
.09091 .17658 Mdot
.13636 .57389 Mdot
.18182 .04415 Mdot
.22727 .30902 Mdot
.27273 .17658 Mdot
.31818 .57389 Mdot
.36364 .04415 Mdot
.40909 .30902 Mdot
.45455 .17658 Mdot
.5 .57389 Mdot
.54545 .04415 Mdot
.59091 .30902 Mdot
.63636 .17658 Mdot
.68182 .57389 Mdot
.72727 .04415 Mdot
.77273 .30902 Mdot
.81818 .17658 Mdot
.86364 .57389 Mdot
.90909 .04415 Mdot
.95455 .30902 Mdot
1 .17658 Mdot
P
P
P
% End of Graphics
MathPictureEnd

:[font = postscript; PostScript; formatAsPostScript; output; inactive; preserveAspect; pictureLeft = 34; pictureWidth = 282; pictureHeight = 174]
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-1.38778e-17 0.0454545 0 0.0441453 [
[(5)] .22727 0 0 2 0 Minner Mrotsboxa
[(10)] .45455 0 0 2 0 Minner Mrotsboxa
[(15)] .68182 0 0 2 0 Minner Mrotsboxa
[(20)] .90909 0 0 2 0 Minner Mrotsboxa
[(Contents Reg1)] .5 0 0 2 0 0 -1 Mouter Mrotsboxa
[(0)] -0.0125 0 1 0 0 Minner Mrotsboxa
[(2)] -0.0125 .08829 1 0 0 Minner Mrotsboxa
[(4)] -0.0125 .17658 1 0 0 Minner Mrotsboxa
[(6)] -0.0125 .26487 1 0 0 Minner Mrotsboxa
[(8)] -0.0125 .35316 1 0 0 Minner Mrotsboxa
[(10)] -0.0125 .44145 1 0 0 Minner Mrotsboxa
[(12)] -0.0125 .52974 1 0 0 Minner Mrotsboxa
[(14)] -0.0125 .61803 1 0 0 Minner Mrotsboxa
[(Contents Reg2)] -0.0125 .30902 1 0 90 -1 0 Mouter Mrotsboxa
[(Measure Reg2 = 4)] .5 .61803 0 -2 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 .61903 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
0 0 .5 r
.001 w
.22727 0 m
.22727 .61803 L
s
P
p
0 0 .5 r
.001 w
.45455 0 m
.45455 .61803 L
s
P
p
0 0 .5 r
.001 w
.68182 0 m
.68182 .61803 L
s
P
p
0 0 .5 r
.001 w
.90909 0 m
.90909 .61803 L
s
P
p
0 0 .5 r
.001 w
0 .08829 m
1 .08829 L
s
P
p
0 0 .5 r
.001 w
0 .17658 m
1 .17658 L
s
P
p
0 0 .5 r
.001 w
0 .26487 m
1 .26487 L
s
P
p
0 0 .5 r
.001 w
0 .35316 m
1 .35316 L
s
P
p
0 0 .5 r
.001 w
0 .44145 m
1 .44145 L
s
P
p
0 0 .5 r
.001 w
0 .52974 m
1 .52974 L
s
P
p
.002 w
.22727 0 m
.22727 .00625 L
s
P
[(5)] .22727 0 0 2 0 Minner Mrotshowa
p
.002 w
.45455 0 m
.45455 .00625 L
s
P
[(10)] .45455 0 0 2 0 Minner Mrotshowa
p
.002 w
.68182 0 m
.68182 .00625 L
s
P
[(15)] .68182 0 0 2 0 Minner Mrotshowa
p
.002 w
.90909 0 m
.90909 .00625 L
s
P
[(20)] .90909 0 0 2 0 Minner Mrotshowa
p
.001 w
.04545 0 m
.04545 .00375 L
s
P
p
.001 w
.09091 0 m
.09091 .00375 L
s
P
p
.001 w
.13636 0 m
.13636 .00375 L
s
P
p
.001 w
.18182 0 m
.18182 .00375 L
s
P
p
.001 w
.27273 0 m
.27273 .00375 L
s
P
p
.001 w
.31818 0 m
.31818 .00375 L
s
P
p
.001 w
.36364 0 m
.36364 .00375 L
s
P
p
.001 w
.40909 0 m
.40909 .00375 L
s
P
p
.001 w
.5 0 m
.5 .00375 L
s
P
p
.001 w
.54545 0 m
.54545 .00375 L
s
P
p
.001 w
.59091 0 m
.59091 .00375 L
s
P
p
.001 w
.63636 0 m
.63636 .00375 L
s
P
p
.001 w
.72727 0 m
.72727 .00375 L
s
P
p
.001 w
.77273 0 m
.77273 .00375 L
s
P
p
.001 w
.81818 0 m
.81818 .00375 L
s
P
p
.001 w
.86364 0 m
.86364 .00375 L
s
P
p
.001 w
.95455 0 m
.95455 .00375 L
s
P
[(Contents Reg1)] .5 0 0 2 0 0 -1 Mouter Mrotshowa
p
.002 w
0 0 m
1 0 L
s
P
p
.002 w
0 0 m
.00625 0 L
s
P
[(0)] -0.0125 0 1 0 0 Minner Mrotshowa
p
.002 w
0 .08829 m
.00625 .08829 L
s
P
[(2)] -0.0125 .08829 1 0 0 Minner Mrotshowa
p
.002 w
0 .17658 m
.00625 .17658 L
s
P
[(4)] -0.0125 .17658 1 0 0 Minner Mrotshowa
p
.002 w
0 .26487 m
.00625 .26487 L
s
P
[(6)] -0.0125 .26487 1 0 0 Minner Mrotshowa
p
.002 w
0 .35316 m
.00625 .35316 L
s
P
[(8)] -0.0125 .35316 1 0 0 Minner Mrotshowa
p
.002 w
0 .44145 m
.00625 .44145 L
s
P
[(10)] -0.0125 .44145 1 0 0 Minner Mrotshowa
p
.002 w
0 .52974 m
.00625 .52974 L
s
P
[(12)] -0.0125 .52974 1 0 0 Minner Mrotshowa
p
.002 w
0 .61803 m
.00625 .61803 L
s
P
[(14)] -0.0125 .61803 1 0 0 Minner Mrotshowa
p
.001 w
0 .01766 m
.00375 .01766 L
s
P
p
.001 w
0 .03532 m
.00375 .03532 L
s
P
p
.001 w
0 .05297 m
.00375 .05297 L
s
P
p
.001 w
0 .07063 m
.00375 .07063 L
s
P
p
.001 w
0 .10595 m
.00375 .10595 L
s
P
p
.001 w
0 .12361 m
.00375 .12361 L
s
P
p
.001 w
0 .14126 m
.00375 .14126 L
s
P
p
.001 w
0 .15892 m
.00375 .15892 L
s
P
p
.001 w
0 .19424 m
.00375 .19424 L
s
P
p
.001 w
0 .2119 m
.00375 .2119 L
s
P
p
.001 w
0 .22956 m
.00375 .22956 L
s
P
p
.001 w
0 .24721 m
.00375 .24721 L
s
P
p
.001 w
0 .28253 m
.00375 .28253 L
s
P
p
.001 w
0 .30019 m
.00375 .30019 L
s
P
p
.001 w
0 .31785 m
.00375 .31785 L
s
P
p
.001 w
0 .3355 m
.00375 .3355 L
s
P
p
.001 w
0 .37082 m
.00375 .37082 L
s
P
p
.001 w
0 .38848 m
.00375 .38848 L
s
P
p
.001 w
0 .40614 m
.00375 .40614 L
s
P
p
.001 w
0 .42379 m
.00375 .42379 L
s
P
p
.001 w
0 .45911 m
.00375 .45911 L
s
P
p
.001 w
0 .47677 m
.00375 .47677 L
s
P
p
.001 w
0 .49443 m
.00375 .49443 L
s
P
p
.001 w
0 .51209 m
.00375 .51209 L
s
P
p
.001 w
0 .5474 m
.00375 .5474 L
s
P
p
.001 w
0 .56506 m
.00375 .56506 L
s
P
p
.001 w
0 .58272 m
.00375 .58272 L
s
P
p
.001 w
0 .60038 m
.00375 .60038 L
s
P
[(Contents Reg2)] -0.0125 .30902 1 0 90 -1 0 Mouter Mrotshowa
p
.002 w
0 0 m
0 .61803 L
s
P
P
p
p
.002 w
0 .61178 m
0 .61803 L
s
P
p
.002 w
.22727 .61178 m
.22727 .61803 L
s
P
p
.002 w
.45455 .61178 m
.45455 .61803 L
s
P
p
.002 w
.68182 .61178 m
.68182 .61803 L
s
P
p
.002 w
.90909 .61178 m
.90909 .61803 L
s
P
p
.001 w
.04545 .61428 m
.04545 .61803 L
s
P
p
.001 w
.09091 .61428 m
.09091 .61803 L
s
P
p
.001 w
.13636 .61428 m
.13636 .61803 L
s
P
p
.001 w
.18182 .61428 m
.18182 .61803 L
s
P
p
.001 w
.27273 .61428 m
.27273 .61803 L
s
P
p
.001 w
.31818 .61428 m
.31818 .61803 L
s
P
p
.001 w
.36364 .61428 m
.36364 .61803 L
s
P
p
.001 w
.40909 .61428 m
.40909 .61803 L
s
P
p
.001 w
.5 .61428 m
.5 .61803 L
s
P
p
.001 w
.54545 .61428 m
.54545 .61803 L
s
P
p
.001 w
.59091 .61428 m
.59091 .61803 L
s
P
p
.001 w
.63636 .61428 m
.63636 .61803 L
s
P
p
.001 w
.72727 .61428 m
.72727 .61803 L
s
P
p
.001 w
.77273 .61428 m
.77273 .61803 L
s
P
p
.001 w
.81818 .61428 m
.81818 .61803 L
s
P
p
.001 w
.86364 .61428 m
.86364 .61803 L
s
P
p
.001 w
.95455 .61428 m
.95455 .61803 L
s
P
p
.002 w
0 .61803 m
1 .61803 L
s
P
[(Measure Reg2 = 4)] .5 .61803 0 -2 Mshowa
p
.002 w
.99375 0 m
1 0 L
s
P
p
.002 w
.99375 .08829 m
1 .08829 L
s
P
p
.002 w
.99375 .17658 m
1 .17658 L
s
P
p
.002 w
.99375 .26487 m
1 .26487 L
s
P
p
.002 w
.99375 .35316 m
1 .35316 L
s
P
p
.002 w
.99375 .44145 m
1 .44145 L
s
P
p
.002 w
.99375 .52974 m
1 .52974 L
s
P
p
.001 w
.99625 .01766 m
1 .01766 L
s
P
p
.001 w
.99625 .03532 m
1 .03532 L
s
P
p
.001 w
.99625 .05297 m
1 .05297 L
s
P
p
.001 w
.99625 .07063 m
1 .07063 L
s
P
p
.001 w
.99625 .10595 m
1 .10595 L
s
P
p
.001 w
.99625 .12361 m
1 .12361 L
s
P
p
.001 w
.99625 .14126 m
1 .14126 L
s
P
p
.001 w
.99625 .15892 m
1 .15892 L
s
P
p
.001 w
.99625 .19424 m
1 .19424 L
s
P
p
.001 w
.99625 .2119 m
1 .2119 L
s
P
p
.001 w
.99625 .22956 m
1 .22956 L
s
P
p
.001 w
.99625 .24721 m
1 .24721 L
s
P
p
.001 w
.99625 .28253 m
1 .28253 L
s
P
p
.001 w
.99625 .30019 m
1 .30019 L
s
P
p
.001 w
.99625 .31785 m
1 .31785 L
s
P
p
.001 w
.99625 .3355 m
1 .3355 L
s
P
p
.001 w
.99625 .37082 m
1 .37082 L
s
P
p
.001 w
.99625 .38848 m
1 .38848 L
s
P
p
.001 w
.99625 .40614 m
1 .40614 L
s
P
p
.001 w
.99625 .42379 m
1 .42379 L
s
P
p
.001 w
.99625 .45911 m
1 .45911 L
s
P
p
.001 w
.99625 .47677 m
1 .47677 L
s
P
p
.001 w
.99625 .49443 m
1 .49443 L
s
P
p
.001 w
.99625 .51209 m
1 .51209 L
s
P
p
.001 w
.99625 .5474 m
1 .5474 L
s
P
p
.001 w
.99625 .56506 m
1 .56506 L
s
P
p
.001 w
.99625 .58272 m
1 .58272 L
s
P
p
.001 w
.99625 .60038 m
1 .60038 L
s
P
p
.002 w
1 0 m
1 .61803 L
s
P
P
p
P
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
p
p
.6 g
[ .01 .01 ] 0 setdash
.004 w
0 .04415 m
.04545 .30902 L
.09091 .17658 L
.13636 .57389 L
.18182 .04415 L
.22727 .30902 L
.27273 .17658 L
.31818 .57389 L
.36364 .04415 L
.40909 .30902 L
.45455 .17658 L
.5 .57389 L
.54545 .04415 L
.59091 .30902 L
.63636 .17658 L
.68182 .57389 L
.72727 .04415 L
.77273 .30902 L
.81818 .17658 L
.86364 .57389 L
.90909 .04415 L
.95455 .30902 L
1 .17658 L
s
P
p
.6 g
p
.02 w
0 .04415 Mdot
.04545 .30902 Mdot
.09091 .17658 Mdot
.13636 .57389 Mdot
.18182 .04415 Mdot
.22727 .30902 Mdot
.27273 .17658 Mdot
.31818 .57389 Mdot
.36364 .04415 Mdot
.40909 .30902 Mdot
.45455 .17658 Mdot
.5 .57389 Mdot
.54545 .04415 Mdot
.59091 .30902 Mdot
.63636 .17658 Mdot
.68182 .57389 Mdot
.72727 .04415 Mdot
.77273 .30902 Mdot
.81818 .17658 Mdot
.86364 .57389 Mdot
.90909 .04415 Mdot
.95455 .30902 Mdot
1 .17658 Mdot
P
P
p
1 0 0 r
.05 w
0 .17658 Mdot
P
P
% End of Graphics
MathPictureEnd

:[font = postscript; PostScript; formatAsPostScript; output; inactive; preserveAspect; pictureLeft = 34; pictureWidth = 282; pictureHeight = 174]
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0714286 0.047619 0 0.0441453 [
[(5)] .16667 0 0 2 0 Minner Mrotsboxa
[(10)] .40476 0 0 2 0 Minner Mrotsboxa
[(15)] .64286 0 0 2 0 Minner Mrotsboxa
[(20)] .88095 0 0 2 0 Minner Mrotsboxa
[(Contents Reg1 {a:x^a mod n = 4})] .5 0 0 2 0 0 -1 Mouter Mrotsboxa
[(0)] -0.0125 0 1 0 0 Minner Mrotsboxa
[(2)] -0.0125 .08829 1 0 0 Minner Mrotsboxa
[(4)] -0.0125 .17658 1 0 0 Minner Mrotsboxa
[(6)] -0.0125 .26487 1 0 0 Minner Mrotsboxa
[(8)] -0.0125 .35316 1 0 0 Minner Mrotsboxa
[(10)] -0.0125 .44145 1 0 0 Minner Mrotsboxa
[(12)] -0.0125 .52974 1 0 0 Minner Mrotsboxa
[(14)] -0.0125 .61803 1 0 0 Minner Mrotsboxa
[(Contents Reg2)] -0.0125 .30902 1 0 90 -1 0 Mouter Mrotsboxa
[(Project Reg1: {a:x^a mod n = 4})] .5 .61803 0 -2 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 .61903 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
0 0 .5 r
.001 w
.16667 0 m
.16667 .61803 L
s
P
p
0 0 .5 r
.001 w
.40476 0 m
.40476 .61803 L
s
P
p
0 0 .5 r
.001 w
.64286 0 m
.64286 .61803 L
s
P
p
0 0 .5 r
.001 w
.88095 0 m
.88095 .61803 L
s
P
p
0 0 .5 r
.001 w
0 .08829 m
1 .08829 L
s
P
p
0 0 .5 r
.001 w
0 .17658 m
1 .17658 L
s
P
p
0 0 .5 r
.001 w
0 .26487 m
1 .26487 L
s
P
p
0 0 .5 r
.001 w
0 .35316 m
1 .35316 L
s
P
p
0 0 .5 r
.001 w
0 .44145 m
1 .44145 L
s
P
p
0 0 .5 r
.001 w
0 .52974 m
1 .52974 L
s
P
p
.002 w
.16667 0 m
.16667 .00625 L
s
P
[(5)] .16667 0 0 2 0 Minner Mrotshowa
p
.002 w
.40476 0 m
.40476 .00625 L
s
P
[(10)] .40476 0 0 2 0 Minner Mrotshowa
p
.002 w
.64286 0 m
.64286 .00625 L
s
P
[(15)] .64286 0 0 2 0 Minner Mrotshowa
p
.002 w
.88095 0 m
.88095 .00625 L
s
P
[(20)] .88095 0 0 2 0 Minner Mrotshowa
p
.001 w
.21429 0 m
.21429 .00375 L
s
P
p
.001 w
.2619 0 m
.2619 .00375 L
s
P
p
.001 w
.30952 0 m
.30952 .00375 L
s
P
p
.001 w
.35714 0 m
.35714 .00375 L
s
P
p
.001 w
.45238 0 m
.45238 .00375 L
s
P
p
.001 w
.5 0 m
.5 .00375 L
s
P
p
.001 w
.54762 0 m
.54762 .00375 L
s
P
p
.001 w
.59524 0 m
.59524 .00375 L
s
P
p
.001 w
.69048 0 m
.69048 .00375 L
s
P
p
.001 w
.7381 0 m
.7381 .00375 L
s
P
p
.001 w
.78571 0 m
.78571 .00375 L
s
P
p
.001 w
.83333 0 m
.83333 .00375 L
s
P
p
.001 w
.11905 0 m
.11905 .00375 L
s
P
p
.001 w
.07143 0 m
.07143 .00375 L
s
P
p
.001 w
.02381 0 m
.02381 .00375 L
s
P
p
.001 w
.92857 0 m
.92857 .00375 L
s
P
p
.001 w
.97619 0 m
.97619 .00375 L
s
P
[(Contents Reg1 {a:x^a mod n = 4})] .5 0 0 2 0 0 -1 Mouter Mrotshowa
p
.002 w
0 0 m
1 0 L
s
P
p
.002 w
0 0 m
.00625 0 L
s
P
[(0)] -0.0125 0 1 0 0 Minner Mrotshowa
p
.002 w
0 .08829 m
.00625 .08829 L
s
P
[(2)] -0.0125 .08829 1 0 0 Minner Mrotshowa
p
.002 w
0 .17658 m
.00625 .17658 L
s
P
[(4)] -0.0125 .17658 1 0 0 Minner Mrotshowa
p
.002 w
0 .26487 m
.00625 .26487 L
s
P
[(6)] -0.0125 .26487 1 0 0 Minner Mrotshowa
p
.002 w
0 .35316 m
.00625 .35316 L
s
P
[(8)] -0.0125 .35316 1 0 0 Minner Mrotshowa
p
.002 w
0 .44145 m
.00625 .44145 L
s
P
[(10)] -0.0125 .44145 1 0 0 Minner Mrotshowa
p
.002 w
0 .52974 m
.00625 .52974 L
s
P
[(12)] -0.0125 .52974 1 0 0 Minner Mrotshowa
p
.002 w
0 .61803 m
.00625 .61803 L
s
P
[(14)] -0.0125 .61803 1 0 0 Minner Mrotshowa
p
.001 w
0 .01766 m
.00375 .01766 L
s
P
p
.001 w
0 .03532 m
.00375 .03532 L
s
P
p
.001 w
0 .05297 m
.00375 .05297 L
s
P
p
.001 w
0 .07063 m
.00375 .07063 L
s
P
p
.001 w
0 .10595 m
.00375 .10595 L
s
P
p
.001 w
0 .12361 m
.00375 .12361 L
s
P
p
.001 w
0 .14126 m
.00375 .14126 L
s
P
p
.001 w
0 .15892 m
.00375 .15892 L
s
P
p
.001 w
0 .19424 m
.00375 .19424 L
s
P
p
.001 w
0 .2119 m
.00375 .2119 L
s
P
p
.001 w
0 .22956 m
.00375 .22956 L
s
P
p
.001 w
0 .24721 m
.00375 .24721 L
s
P
p
.001 w
0 .28253 m
.00375 .28253 L
s
P
p
.001 w
0 .30019 m
.00375 .30019 L
s
P
p
.001 w
0 .31785 m
.00375 .31785 L
s
P
p
.001 w
0 .3355 m
.00375 .3355 L
s
P
p
.001 w
0 .37082 m
.00375 .37082 L
s
P
p
.001 w
0 .38848 m
.00375 .38848 L
s
P
p
.001 w
0 .40614 m
.00375 .40614 L
s
P
p
.001 w
0 .42379 m
.00375 .42379 L
s
P
p
.001 w
0 .45911 m
.00375 .45911 L
s
P
p
.001 w
0 .47677 m
.00375 .47677 L
s
P
p
.001 w
0 .49443 m
.00375 .49443 L
s
P
p
.001 w
0 .51209 m
.00375 .51209 L
s
P
p
.001 w
0 .5474 m
.00375 .5474 L
s
P
p
.001 w
0 .56506 m
.00375 .56506 L
s
P
p
.001 w
0 .58272 m
.00375 .58272 L
s
P
p
.001 w
0 .60038 m
.00375 .60038 L
s
P
[(Contents Reg2)] -0.0125 .30902 1 0 90 -1 0 Mouter Mrotshowa
p
.002 w
0 0 m
0 .61803 L
s
P
P
p
p
.002 w
.16667 .61178 m
.16667 .61803 L
s
P
p
.002 w
.40476 .61178 m
.40476 .61803 L
s
P
p
.002 w
.64286 .61178 m
.64286 .61803 L
s
P
p
.002 w
.88095 .61178 m
.88095 .61803 L
s
P
p
.001 w
.21429 .61428 m
.21429 .61803 L
s
P
p
.001 w
.2619 .61428 m
.2619 .61803 L
s
P
p
.001 w
.30952 .61428 m
.30952 .61803 L
s
P
p
.001 w
.35714 .61428 m
.35714 .61803 L
s
P
p
.001 w
.45238 .61428 m
.45238 .61803 L
s
P
p
.001 w
.5 .61428 m
.5 .61803 L
s
P
p
.001 w
.54762 .61428 m
.54762 .61803 L
s
P
p
.001 w
.59524 .61428 m
.59524 .61803 L
s
P
p
.001 w
.69048 .61428 m
.69048 .61803 L
s
P
p
.001 w
.7381 .61428 m
.7381 .61803 L
s
P
p
.001 w
.78571 .61428 m
.78571 .61803 L
s
P
p
.001 w
.83333 .61428 m
.83333 .61803 L
s
P
p
.001 w
.11905 .61428 m
.11905 .61803 L
s
P
p
.001 w
.07143 .61428 m
.07143 .61803 L
s
P
p
.001 w
.02381 .61428 m
.02381 .61803 L
s
P
p
.001 w
.92857 .61428 m
.92857 .61803 L
s
P
p
.001 w
.97619 .61428 m
.97619 .61803 L
s
P
p
.002 w
0 .61803 m
1 .61803 L
s
P
[(Project Reg1: {a:x^a mod n = 4})] .5 .61803 0 -2 Mshowa
p
.002 w
.99375 0 m
1 0 L
s
P
p
.002 w
.99375 .08829 m
1 .08829 L
s
P
p
.002 w
.99375 .17658 m
1 .17658 L
s
P
p
.002 w
.99375 .26487 m
1 .26487 L
s
P
p
.002 w
.99375 .35316 m
1 .35316 L
s
P
p
.002 w
.99375 .44145 m
1 .44145 L
s
P
p
.002 w
.99375 .52974 m
1 .52974 L
s
P
p
.001 w
.99625 .01766 m
1 .01766 L
s
P
p
.001 w
.99625 .03532 m
1 .03532 L
s
P
p
.001 w
.99625 .05297 m
1 .05297 L
s
P
p
.001 w
.99625 .07063 m
1 .07063 L
s
P
p
.001 w
.99625 .10595 m
1 .10595 L
s
P
p
.001 w
.99625 .12361 m
1 .12361 L
s
P
p
.001 w
.99625 .14126 m
1 .14126 L
s
P
p
.001 w
.99625 .15892 m
1 .15892 L
s
P
p
.001 w
.99625 .19424 m
1 .19424 L
s
P
p
.001 w
.99625 .2119 m
1 .2119 L
s
P
p
.001 w
.99625 .22956 m
1 .22956 L
s
P
p
.001 w
.99625 .24721 m
1 .24721 L
s
P
p
.001 w
.99625 .28253 m
1 .28253 L
s
P
p
.001 w
.99625 .30019 m
1 .30019 L
s
P
p
.001 w
.99625 .31785 m
1 .31785 L
s
P
p
.001 w
.99625 .3355 m
1 .3355 L
s
P
p
.001 w
.99625 .37082 m
1 .37082 L
s
P
p
.001 w
.99625 .38848 m
1 .38848 L
s
P
p
.001 w
.99625 .40614 m
1 .40614 L
s
P
p
.001 w
.99625 .42379 m
1 .42379 L
s
P
p
.001 w
.99625 .45911 m
1 .45911 L
s
P
p
.001 w
.99625 .47677 m
1 .47677 L
s
P
p
.001 w
.99625 .49443 m
1 .49443 L
s
P
p
.001 w
.99625 .51209 m
1 .51209 L
s
P
p
.001 w
.99625 .5474 m
1 .5474 L
s
P
p
.001 w
.99625 .56506 m
1 .56506 L
s
P
p
.001 w
.99625 .58272 m
1 .58272 L
s
P
p
.001 w
.99625 .60038 m
1 .60038 L
s
P
p
.002 w
1 0 m
1 .61803 L
s
P
P
p
p
.002 w
.16667 0 m
.16667 .61803 L
s
P
P
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
p
p
.02 w
.02381 .17658 Mdot
.21429 .17658 Mdot
.40476 .17658 Mdot
.59524 .17658 Mdot
.78571 .17658 Mdot
.97619 .17658 Mdot
P
P
% End of Graphics
MathPictureEnd

:[font = postscript; PostScript; formatAsPostScript; output; inactive; preserveAspect; pictureLeft = 34; pictureWidth = 282; pictureHeight = 174]
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.00393546 0.603319 0.109514 [
[(0)] .02381 0 0 2 0 Minner Mrotsboxa
[(50)] .22058 0 0 2 0 Minner Mrotsboxa
[(100)] .41736 0 0 2 0 Minner Mrotsboxa
[(150)] .61413 0 0 2 0 Minner Mrotsboxa
[(200)] .8109 0 0 2 0 Minner Mrotsboxa
[(Contents Reg1 {a:x^a mod n = 4})] .5 0 0 2 0 0 -1 Mouter Mrotsboxa
[(0.00001)] -0.0125 .05575 1 0 0 Minner Mrotsboxa
[(0.0001)] -0.0125 .16526 1 0 0 Minner Mrotsboxa
[(0.001)] -0.0125 .27478 1 0 0 Minner Mrotsboxa
[(0.01)] -0.0125 .38429 1 0 0 Minner Mrotsboxa
[(0.1)] -0.0125 .4938 1 0 0 Minner Mrotsboxa
[(1)] -0.0125 .60332 1 0 0 Minner Mrotsboxa
[(ln\(Pr\(Measure a\)\))] -0.0125 .30902 1 0 90 -1 0 Mouter Mrotsboxa
[(Compute Discrete Fourier Transform of Reg1)] .5 .61803 0 -2 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 .61903 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
0 0 .5 r
.001 w
.22058 0 m
.22058 .61803 L
s
P
p
0 0 .5 r
.001 w
.41736 0 m
.41736 .61803 L
s
P
p
0 0 .5 r
.001 w
.61413 0 m
.61413 .61803 L
s
P
p
0 0 .5 r
.001 w
.8109 0 m
.8109 .61803 L
s
P
p
0 0 .5 r
.001 w
0 .05575 m
1 .05575 L
s
P
p
0 0 .5 r
.001 w
0 .16526 m
1 .16526 L
s
P
p
0 0 .5 r
.001 w
0 .27478 m
1 .27478 L
s
P
p
0 0 .5 r
.001 w
0 .38429 m
1 .38429 L
s
P
p
0 0 .5 r
.001 w
0 .4938 m
1 .4938 L
s
P
p
0 0 .5 r
.001 w
0 .60332 m
1 .60332 L
s
P
p
0 0 .5 r
.001 w
0 .01217 m
1 .01217 L
s
P
p
0 0 .5 r
.001 w
0 .02278 m
1 .02278 L
s
P
p
0 0 .5 r
.001 w
0 .03145 m
1 .03145 L
s
P
p
0 0 .5 r
.001 w
0 .03879 m
1 .03879 L
s
P
p
0 0 .5 r
.001 w
0 .04514 m
1 .04514 L
s
P
p
0 0 .5 r
.001 w
0 .05074 m
1 .05074 L
s
P
p
0 0 .5 r
.001 w
0 .08872 m
1 .08872 L
s
P
p
0 0 .5 r
.001 w
0 .108 m
1 .108 L
s
P
p
0 0 .5 r
.001 w
0 .12168 m
1 .12168 L
s
P
p
0 0 .5 r
.001 w
0 .1323 m
1 .1323 L
s
P
p
0 0 .5 r
.001 w
0 .14097 m
1 .14097 L
s
P
p
0 0 .5 r
.001 w
0 .1483 m
1 .1483 L
s
P
p
0 0 .5 r
.001 w
0 .15465 m
1 .15465 L
s
P
p
0 0 .5 r
.001 w
0 .16025 m
1 .16025 L
s
P
p
0 0 .5 r
.001 w
0 .19823 m
1 .19823 L
s
P
p
0 0 .5 r
.001 w
0 .21751 m
1 .21751 L
s
P
p
0 0 .5 r
.001 w
0 .2312 m
1 .2312 L
s
P
p
0 0 .5 r
.001 w
0 .24181 m
1 .24181 L
s
P
p
0 0 .5 r
.001 w
0 .25048 m
1 .25048 L
s
P
p
0 0 .5 r
.001 w
0 .25781 m
1 .25781 L
s
P
p
0 0 .5 r
.001 w
0 .26416 m
1 .26416 L
s
P
p
0 0 .5 r
.001 w
0 .26977 m
1 .26977 L
s
P
p
0 0 .5 r
.001 w
0 .30774 m
1 .30774 L
s
P
p
0 0 .5 r
.001 w
0 .32703 m
1 .32703 L
s
P
p
0 0 .5 r
.001 w
0 .34071 m
1 .34071 L
s
P
p
0 0 .5 r
.001 w
0 .35132 m
1 .35132 L
s
P
p
0 0 .5 r
.001 w
0 .36 m
1 .36 L
s
P
p
0 0 .5 r
.001 w
0 .36733 m
1 .36733 L
s
P
p
0 0 .5 r
.001 w
0 .37368 m
1 .37368 L
s
P
p
0 0 .5 r
.001 w
0 .37928 m
1 .37928 L
s
P
p
0 0 .5 r
.001 w
0 .41726 m
1 .41726 L
s
P
p
0 0 .5 r
.001 w
0 .43654 m
1 .43654 L
s
P
p
0 0 .5 r
.001 w
0 .45022 m
1 .45022 L
s
P
p
0 0 .5 r
.001 w
0 .46084 m
1 .46084 L
s
P
p
0 0 .5 r
.001 w
0 .46951 m
1 .46951 L
s
P
p
0 0 .5 r
.001 w
0 .47684 m
1 .47684 L
s
P
p
0 0 .5 r
.001 w
0 .48319 m
1 .48319 L
s
P
p
0 0 .5 r
.001 w
0 .48879 m
1 .48879 L
s
P
p
0 0 .5 r
.001 w
0 .52677 m
1 .52677 L
s
P
p
0 0 .5 r
.001 w
0 .54606 m
1 .54606 L
s
P
p
0 0 .5 r
.001 w
0 .55974 m
1 .55974 L
s
P
p
0 0 .5 r
.001 w
0 .57035 m
1 .57035 L
s
P
p
0 0 .5 r
.001 w
0 .57902 m
1 .57902 L
s
P
p
0 0 .5 r
.001 w
0 .58635 m
1 .58635 L
s
P
p
0 0 .5 r
.001 w
0 .59271 m
1 .59271 L
s
P
p
0 0 .5 r
.001 w
0 .59831 m
1 .59831 L
s
P
p
.002 w
.02381 0 m
.02381 .00625 L
s
P
[(0)] .02381 0 0 2 0 Minner Mrotshowa
p
.002 w
.22058 0 m
.22058 .00625 L
s
P
[(50)] .22058 0 0 2 0 Minner Mrotshowa
p
.002 w
.41736 0 m
.41736 .00625 L
s
P
[(100)] .41736 0 0 2 0 Minner Mrotshowa
p
.002 w
.61413 0 m
.61413 .00625 L
s
P
[(150)] .61413 0 0 2 0 Minner Mrotshowa
p
.002 w
.8109 0 m
.8109 .00625 L
s
P
[(200)] .8109 0 0 2 0 Minner Mrotshowa
p
.001 w
.06316 0 m
.06316 .00375 L
s
P
p
.001 w
.10252 0 m
.10252 .00375 L
s
P
p
.001 w
.14187 0 m
.14187 .00375 L
s
P
p
.001 w
.18123 0 m
.18123 .00375 L
s
P
p
.001 w
.25994 0 m
.25994 .00375 L
s
P
p
.001 w
.29929 0 m
.29929 .00375 L
s
P
p
.001 w
.33865 0 m
.33865 .00375 L
s
P
p
.001 w
.378 0 m
.378 .00375 L
s
P
p
.001 w
.45671 0 m
.45671 .00375 L
s
P
p
.001 w
.49606 0 m
.49606 .00375 L
s
P
p
.001 w
.53542 0 m
.53542 .00375 L
s
P
p
.001 w
.57477 0 m
.57477 .00375 L
s
P
p
.001 w
.65348 0 m
.65348 .00375 L
s
P
p
.001 w
.69284 0 m
.69284 .00375 L
s
P
p
.001 w
.73219 0 m
.73219 .00375 L
s
P
p
.001 w
.77155 0 m
.77155 .00375 L
s
P
p
.001 w
.85026 0 m
.85026 .00375 L
s
P
p
.001 w
.88961 0 m
.88961 .00375 L
s
P
p
.001 w
.92896 0 m
.92896 .00375 L
s
P
p
.001 w
.96832 0 m
.96832 .00375 L
s
P
[(Contents Reg1 {a:x^a mod n = 4})] .5 0 0 2 0 0 -1 Mouter Mrotshowa
p
.002 w
0 0 m
1 0 L
s
P
p
.002 w
0 .05575 m
.00625 .05575 L
s
P
[(0.00001)] -0.0125 .05575 1 0 0 Minner Mrotshowa
p
.002 w
0 .16526 m
.00625 .16526 L
s
P
[(0.0001)] -0.0125 .16526 1 0 0 Minner Mrotshowa
p
.002 w
0 .27478 m
.00625 .27478 L
s
P
[(0.001)] -0.0125 .27478 1 0 0 Minner Mrotshowa
p
.002 w
0 .38429 m
.00625 .38429 L
s
P
[(0.01)] -0.0125 .38429 1 0 0 Minner Mrotshowa
p
.002 w
0 .4938 m
.00625 .4938 L
s
P
[(0.1)] -0.0125 .4938 1 0 0 Minner Mrotshowa
p
.002 w
0 .60332 m
.00625 .60332 L
s
P
[(1)] -0.0125 .60332 1 0 0 Minner Mrotshowa
p
.001 w
0 .01217 m
.00375 .01217 L
s
P
p
.001 w
0 .02278 m
.00375 .02278 L
s
P
p
.001 w
0 .03145 m
.00375 .03145 L
s
P
p
.001 w
0 .03879 m
.00375 .03879 L
s
P
p
.001 w
0 .04514 m
.00375 .04514 L
s
P
p
.001 w
0 .05074 m
.00375 .05074 L
s
P
p
.001 w
0 .08872 m
.00375 .08872 L
s
P
p
.001 w
0 .108 m
.00375 .108 L
s
P
p
.001 w
0 .12168 m
.00375 .12168 L
s
P
p
.001 w
0 .1323 m
.00375 .1323 L
s
P
p
.001 w
0 .14097 m
.00375 .14097 L
s
P
p
.001 w
0 .1483 m
.00375 .1483 L
s
P
p
.001 w
0 .15465 m
.00375 .15465 L
s
P
p
.001 w
0 .16025 m
.00375 .16025 L
s
P
p
.001 w
0 .19823 m
.00375 .19823 L
s
P
p
.001 w
0 .21751 m
.00375 .21751 L
s
P
p
.001 w
0 .2312 m
.00375 .2312 L
s
P
p
.001 w
0 .24181 m
.00375 .24181 L
s
P
p
.001 w
0 .25048 m
.00375 .25048 L
s
P
p
.001 w
0 .25781 m
.00375 .25781 L
s
P
p
.001 w
0 .26416 m
.00375 .26416 L
s
P
p
.001 w
0 .26977 m
.00375 .26977 L
s
P
p
.001 w
0 .30774 m
.00375 .30774 L
s
P
p
.001 w
0 .32703 m
.00375 .32703 L
s
P
p
.001 w
0 .34071 m
.00375 .34071 L
s
P
p
.001 w
0 .35132 m
.00375 .35132 L
s
P
p
.001 w
0 .36 m
.00375 .36 L
s
P
p
.001 w
0 .36733 m
.00375 .36733 L
s
P
p
.001 w
0 .37368 m
.00375 .37368 L
s
P
p
.001 w
0 .37928 m
.00375 .37928 L
s
P
p
.001 w
0 .41726 m
.00375 .41726 L
s
P
p
.001 w
0 .43654 m
.00375 .43654 L
s
P
p
.001 w
0 .45022 m
.00375 .45022 L
s
P
p
.001 w
0 .46084 m
.00375 .46084 L
s
P
p
.001 w
0 .46951 m
.00375 .46951 L
s
P
p
.001 w
0 .47684 m
.00375 .47684 L
s
P
p
.001 w
0 .48319 m
.00375 .48319 L
s
P
p
.001 w
0 .48879 m
.00375 .48879 L
s
P
p
.001 w
0 .52677 m
.00375 .52677 L
s
P
p
.001 w
0 .54606 m
.00375 .54606 L
s
P
p
.001 w
0 .55974 m
.00375 .55974 L
s
P
p
.001 w
0 .57035 m
.00375 .57035 L
s
P
p
.001 w
0 .57902 m
.00375 .57902 L
s
P
p
.001 w
0 .58635 m
.00375 .58635 L
s
P
p
.001 w
0 .59271 m
.00375 .59271 L
s
P
p
.001 w
0 .59831 m
.00375 .59831 L
s
P
[(ln\(Pr\(Measure a\)\))] -0.0125 .30902 1 0 90 -1 0 Mouter Mrotshowa
p
.002 w
0 0 m
0 .61803 L
s
P
P
p
p
.002 w
.02381 .61178 m
.02381 .61803 L
s
P
p
.002 w
.22058 .61178 m
.22058 .61803 L
s
P
p
.002 w
.41736 .61178 m
.41736 .61803 L
s
P
p
.002 w
.61413 .61178 m
.61413 .61803 L
s
P
p
.002 w
.8109 .61178 m
.8109 .61803 L
s
P
p
.001 w
.06316 .61428 m
.06316 .61803 L
s
P
p
.001 w
.10252 .61428 m
.10252 .61803 L
s
P
p
.001 w
.14187 .61428 m
.14187 .61803 L
s
P
p
.001 w
.18123 .61428 m
.18123 .61803 L
s
P
p
.001 w
.25994 .61428 m
.25994 .61803 L
s
P
p
.001 w
.29929 .61428 m
.29929 .61803 L
s
P
p
.001 w
.33865 .61428 m
.33865 .61803 L
s
P
p
.001 w
.378 .61428 m
.378 .61803 L
s
P
p
.001 w
.45671 .61428 m
.45671 .61803 L
s
P
p
.001 w
.49606 .61428 m
.49606 .61803 L
s
P
p
.001 w
.53542 .61428 m
.53542 .61803 L
s
P
p
.001 w
.57477 .61428 m
.57477 .61803 L
s
P
p
.001 w
.65348 .61428 m
.65348 .61803 L
s
P
p
.001 w
.69284 .61428 m
.69284 .61803 L
s
P
p
.001 w
.73219 .61428 m
.73219 .61803 L
s
P
p
.001 w
.77155 .61428 m
.77155 .61803 L
s
P
p
.001 w
.85026 .61428 m
.85026 .61803 L
s
P
p
.001 w
.88961 .61428 m
.88961 .61803 L
s
P
p
.001 w
.92896 .61428 m
.92896 .61803 L
s
P
p
.001 w
.96832 .61428 m
.96832 .61803 L
s
P
p
.002 w
0 .61803 m
1 .61803 L
s
P
[(Compute Discrete Fourier Transform of Reg1)] .5 .61803 0 -2 Mshowa
p
.002 w
.99375 .05575 m
1 .05575 L
s
P
p
.002 w
.99375 .16526 m
1 .16526 L
s
P
p
.002 w
.99375 .27478 m
1 .27478 L
s
P
p
.002 w
.99375 .38429 m
1 .38429 L
s
P
p
.002 w
.99375 .4938 m
1 .4938 L
s
P
p
.002 w
.99375 .60332 m
1 .60332 L
s
P
p
.001 w
.99625 .01217 m
1 .01217 L
s
P
p
.001 w
.99625 .02278 m
1 .02278 L
s
P
p
.001 w
.99625 .03145 m
1 .03145 L
s
P
p
.001 w
.99625 .03879 m
1 .03879 L
s
P
p
.001 w
.99625 .04514 m
1 .04514 L
s
P
p
.001 w
.99625 .05074 m
1 .05074 L
s
P
p
.001 w
.99625 .08872 m
1 .08872 L
s
P
p
.001 w
.99625 .108 m
1 .108 L
s
P
p
.001 w
.99625 .12168 m
1 .12168 L
s
P
p
.001 w
.99625 .1323 m
1 .1323 L
s
P
p
.001 w
.99625 .14097 m
1 .14097 L
s
P
p
.001 w
.99625 .1483 m
1 .1483 L
s
P
p
.001 w
.99625 .15465 m
1 .15465 L
s
P
p
.001 w
.99625 .16025 m
1 .16025 L
s
P
p
.001 w
.99625 .19823 m
1 .19823 L
s
P
p
.001 w
.99625 .21751 m
1 .21751 L
s
P
p
.001 w
.99625 .2312 m
1 .2312 L
s
P
p
.001 w
.99625 .24181 m
1 .24181 L
s
P
p
.001 w
.99625 .25048 m
1 .25048 L
s
P
p
.001 w
.99625 .25781 m
1 .25781 L
s
P
p
.001 w
.99625 .26416 m
1 .26416 L
s
P
p
.001 w
.99625 .26977 m
1 .26977 L
s
P
p
.001 w
.99625 .30774 m
1 .30774 L
s
P
p
.001 w
.99625 .32703 m
1 .32703 L
s
P
p
.001 w
.99625 .34071 m
1 .34071 L
s
P
p
.001 w
.99625 .35132 m
1 .35132 L
s
P
p
.001 w
.99625 .36 m
1 .36 L
s
P
p
.001 w
.99625 .36733 m
1 .36733 L
s
P
p
.001 w
.99625 .37368 m
1 .37368 L
s
P
p
.001 w
.99625 .37928 m
1 .37928 L
s
P
p
.001 w
.99625 .41726 m
1 .41726 L
s
P
p
.001 w
.99625 .43654 m
1 .43654 L
s
P
p
.001 w
.99625 .45022 m
1 .45022 L
s
P
p
.001 w
.99625 .46084 m
1 .46084 L
s
P
p
.001 w
.99625 .46951 m
1 .46951 L
s
P
p
.001 w
.99625 .47684 m
1 .47684 L
s
P
p
.001 w
.99625 .48319 m
1 .48319 L
s
P
p
.001 w
.99625 .48879 m
1 .48879 L
s
P
p
.001 w
.99625 .52677 m
1 .52677 L
s
P
p
.001 w
.99625 .54606 m
1 .54606 L
s
P
p
.001 w
.99625 .55974 m
1 .55974 L
s
P
p
.001 w
.99625 .57035 m
1 .57035 L
s
P
p
.001 w
.99625 .57902 m
1 .57902 L
s
P
p
.001 w
.99625 .58635 m
1 .58635 L
s
P
p
.001 w
.99625 .59271 m
1 .59271 L
s
P
p
.001 w
.99625 .59831 m
1 .59831 L
s
P
p
.002 w
1 0 m
1 .61803 L
s
P
P
p
P
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
p
p
.01 w
.02381 .53758 Mdot
.02774 .01472 Mdot
.03168 .01483 Mdot
.03562 .01503 Mdot
.03955 .01531 Mdot
.04349 .01567 Mdot
.04742 .01611 Mdot
.05136 .01663 Mdot
.05529 .01723 Mdot
.05923 .01792 Mdot
.06316 .01869 Mdot
.0671 .01954 Mdot
.07104 .02048 Mdot
.07497 .0215 Mdot
.07891 .02262 Mdot
.08284 .02382 Mdot
.08678 .02511 Mdot
.09071 .02649 Mdot
.09465 .02797 Mdot
.09858 .02955 Mdot
.10252 .03122 Mdot
.10645 .033 Mdot
.11039 .03488 Mdot
.11433 .03686 Mdot
.11826 .03896 Mdot
.1222 .04117 Mdot
.12613 .04349 Mdot
.13007 .04594 Mdot
.134 .04852 Mdot
.13794 .05123 Mdot
.14187 .05407 Mdot
.14581 .05706 Mdot
.14974 .0602 Mdot
.15368 .06349 Mdot
.15762 .06695 Mdot
.16155 .07059 Mdot
.16549 .07442 Mdot
.16942 .07844 Mdot
.17336 .08267 Mdot
.17729 .08713 Mdot
.18123 .09184 Mdot
.18516 .09681 Mdot
.1891 .10207 Mdot
.19303 .10764 Mdot
.19697 .11356 Mdot
.20091 .11987 Mdot
.20484 .1266 Mdot
.20878 .13382 Mdot
.21271 .14159 Mdot
.21665 .14998 Mdot
.22058 .15912 Mdot
.22452 .16913 Mdot
.22845 .18019 Mdot
.23239 .19255 Mdot
.23632 .20656 Mdot
.24026 .22273 Mdot
.2442 .24186 Mdot
.24813 .26536 Mdot
.25207 .29592 Mdot
.256 .34003 Mdot
.25994 .42179 Mdot
.26387 .52751 Mdot
.26781 .37569 Mdot
.27174 .3211 Mdot
.27568 .2875 Mdot
.27961 .26341 Mdot
.28355 .24481 Mdot
.28749 .22977 Mdot
.29142 .21726 Mdot
.29536 .20664 Mdot
.29929 .19749 Mdot
.30323 .18952 Mdot
.30716 .18252 Mdot
.3111 .17635 Mdot
.31503 .17088 Mdot
.31897 .16602 Mdot
.3229 .1617 Mdot
.32684 .15787 Mdot
.33078 .15447 Mdot
.33471 .15147 Mdot
.33865 .14884 Mdot
.34258 .14654 Mdot
.34652 .14457 Mdot
.35045 .14289 Mdot
.35439 .14151 Mdot
.35832 .14039 Mdot
.36226 .13953 Mdot
.36619 .13893 Mdot
.37013 .13858 Mdot
.37407 .13846 Mdot
.378 .13859 Mdot
.38194 .13895 Mdot
.38587 .13955 Mdot
.38981 .14038 Mdot
.39374 .14146 Mdot
.39768 .14277 Mdot
.40161 .14433 Mdot
.40555 .14615 Mdot
.40948 .14823 Mdot
.41342 .15058 Mdot
.41736 .15321 Mdot
.42129 .15615 Mdot
.42523 .1594 Mdot
.42916 .16299 Mdot
.4331 .16694 Mdot
.43703 .17129 Mdot
.44097 .17607 Mdot
.4449 .18133 Mdot
.44884 .18713 Mdot
.45277 .19352 Mdot
.45671 .2006 Mdot
.46065 .20847 Mdot
.46458 .21729 Mdot
.46852 .22724 Mdot
.47245 .23859 Mdot
.47639 .25171 Mdot
.48032 .26719 Mdot
.48426 .28593 Mdot
.48819 .30956 Mdot
.49213 .34136 Mdot
.49606 .38981 Mdot
.5 .49424 Mdot
.50394 .49424 Mdot
.50787 .38981 Mdot
.51181 .34136 Mdot
.51574 .30956 Mdot
.51968 .28593 Mdot
.52361 .26719 Mdot
.52755 .25171 Mdot
.53148 .23859 Mdot
.53542 .22724 Mdot
.53935 .21729 Mdot
.54329 .20847 Mdot
.54723 .2006 Mdot
.55116 .19352 Mdot
.5551 .18713 Mdot
.55903 .18133 Mdot
.56297 .17607 Mdot
.5669 .17129 Mdot
.57084 .16694 Mdot
.57477 .16299 Mdot
.57871 .1594 Mdot
.58264 .15615 Mdot
.58658 .15321 Mdot
.59052 .15058 Mdot
.59445 .14823 Mdot
.59839 .14615 Mdot
.60232 .14433 Mdot
.60626 .14277 Mdot
.61019 .14146 Mdot
.61413 .14038 Mdot
.61806 .13955 Mdot
.622 .13895 Mdot
.62593 .13859 Mdot
.62987 .13846 Mdot
.63381 .13858 Mdot
.63774 .13893 Mdot
.64168 .13953 Mdot
.64561 .14039 Mdot
.64955 .14151 Mdot
.65348 .14289 Mdot
.65742 .14457 Mdot
.66135 .14654 Mdot
.66529 .14884 Mdot
.66922 .15147 Mdot
.67316 .15447 Mdot
.6771 .15787 Mdot
.68103 .1617 Mdot
.68497 .16602 Mdot
.6889 .17088 Mdot
.69284 .17635 Mdot
.69677 .18252 Mdot
.70071 .18952 Mdot
.70464 .19749 Mdot
.70858 .20664 Mdot
.71251 .21726 Mdot
.71645 .22977 Mdot
.72039 .24481 Mdot
.72432 .26341 Mdot
.72826 .2875 Mdot
.73219 .3211 Mdot
.73613 .37569 Mdot
.74006 .52751 Mdot
.744 .42179 Mdot
.74793 .34003 Mdot
.75187 .29592 Mdot
.7558 .26536 Mdot
.75974 .24186 Mdot
.76368 .22273 Mdot
.76761 .20656 Mdot
.77155 .19255 Mdot
.77548 .18019 Mdot
.77942 .16913 Mdot
.78335 .15912 Mdot
.78729 .14998 Mdot
.79122 .14159 Mdot
.79516 .13382 Mdot
.79909 .1266 Mdot
.80303 .11987 Mdot
.80697 .11356 Mdot
.8109 .10764 Mdot
.81484 .10207 Mdot
.81877 .09681 Mdot
.82271 .09184 Mdot
.82664 .08713 Mdot
.83058 .08267 Mdot
.83451 .07844 Mdot
.83845 .07442 Mdot
.84238 .07059 Mdot
.84632 .06695 Mdot
.85026 .06349 Mdot
.85419 .0602 Mdot
.85813 .05706 Mdot
.86206 .05407 Mdot
.866 .05123 Mdot
.86993 .04852 Mdot
.87387 .04594 Mdot
.8778 .04349 Mdot
.88174 .04117 Mdot
.88567 .03896 Mdot
.88961 .03686 Mdot
.89355 .03488 Mdot
.89748 .033 Mdot
.90142 .03122 Mdot
.90535 .02955 Mdot
.90929 .02797 Mdot
.91322 .02649 Mdot
.91716 .02511 Mdot
.92109 .02382 Mdot
.92503 .02262 Mdot
.92896 .0215 Mdot
.9329 .02048 Mdot
.93684 .01954 Mdot
.94077 .01869 Mdot
.94471 .01792 Mdot
.94864 .01723 Mdot
.95258 .01663 Mdot
.95651 .01611 Mdot
.96045 .01567 Mdot
.96438 .01531 Mdot
.96832 .01503 Mdot
.97226 .01483 Mdot
.97619 .01472 Mdot
P
P
% End of Graphics
MathPictureEnd

:[font = postscript; PostScript; formatAsPostScript; output; inactive; preserveAspect; pictureLeft = 34; pictureWidth = 282; pictureHeight = 174]
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.00393546 0.603319 0.109514 [
[(0)] .02381 0 0 2 0 Minner Mrotsboxa
[(50)] .22058 0 0 2 0 Minner Mrotsboxa
[(100)] .41736 0 0 2 0 Minner Mrotsboxa
[(150)] .61413 0 0 2 0 Minner Mrotsboxa
[(200)] .8109 0 0 2 0 Minner Mrotsboxa
[(Contents Reg1 {a:x^a mod n = 4})] .5 0 0 2 0 0 -1 Mouter Mrotsboxa
[(0.00001)] -0.0125 .05575 1 0 0 Minner Mrotsboxa
[(0.0001)] -0.0125 .16526 1 0 0 Minner Mrotsboxa
[(0.001)] -0.0125 .27478 1 0 0 Minner Mrotsboxa
[(0.01)] -0.0125 .38429 1 0 0 Minner Mrotsboxa
[(0.1)] -0.0125 .4938 1 0 0 Minner Mrotsboxa
[(1)] -0.0125 .60332 1 0 0 Minner Mrotsboxa
[(ln\(Pr\(Measure a\)\))] -0.0125 .30902 1 0 90 -1 0 Mouter Mrotsboxa
[(Compute Discrete Fourier Transform of Reg1)] .5 .61803 0 -2 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 .61903 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
0 0 .5 r
.001 w
.22058 0 m
.22058 .61803 L
s
P
p
0 0 .5 r
.001 w
.41736 0 m
.41736 .61803 L
s
P
p
0 0 .5 r
.001 w
.61413 0 m
.61413 .61803 L
s
P
p
0 0 .5 r
.001 w
.8109 0 m
.8109 .61803 L
s
P
p
0 0 .5 r
.001 w
0 .05575 m
1 .05575 L
s
P
p
0 0 .5 r
.001 w
0 .16526 m
1 .16526 L
s
P
p
0 0 .5 r
.001 w
0 .27478 m
1 .27478 L
s
P
p
0 0 .5 r
.001 w
0 .38429 m
1 .38429 L
s
P
p
0 0 .5 r
.001 w
0 .4938 m
1 .4938 L
s
P
p
0 0 .5 r
.001 w
0 .60332 m
1 .60332 L
s
P
p
0 0 .5 r
.001 w
0 .01217 m
1 .01217 L
s
P
p
0 0 .5 r
.001 w
0 .02278 m
1 .02278 L
s
P
p
0 0 .5 r
.001 w
0 .03145 m
1 .03145 L
s
P
p
0 0 .5 r
.001 w
0 .03879 m
1 .03879 L
s
P
p
0 0 .5 r
.001 w
0 .04514 m
1 .04514 L
s
P
p
0 0 .5 r
.001 w
0 .05074 m
1 .05074 L
s
P
p
0 0 .5 r
.001 w
0 .08872 m
1 .08872 L
s
P
p
0 0 .5 r
.001 w
0 .108 m
1 .108 L
s
P
p
0 0 .5 r
.001 w
0 .12168 m
1 .12168 L
s
P
p
0 0 .5 r
.001 w
0 .1323 m
1 .1323 L
s
P
p
0 0 .5 r
.001 w
0 .14097 m
1 .14097 L
s
P
p
0 0 .5 r
.001 w
0 .1483 m
1 .1483 L
s
P
p
0 0 .5 r
.001 w
0 .15465 m
1 .15465 L
s
P
p
0 0 .5 r
.001 w
0 .16025 m
1 .16025 L
s
P
p
0 0 .5 r
.001 w
0 .19823 m
1 .19823 L
s
P
p
0 0 .5 r
.001 w
0 .21751 m
1 .21751 L
s
P
p
0 0 .5 r
.001 w
0 .2312 m
1 .2312 L
s
P
p
0 0 .5 r
.001 w
0 .24181 m
1 .24181 L
s
P
p
0 0 .5 r
.001 w
0 .25048 m
1 .25048 L
s
P
p
0 0 .5 r
.001 w
0 .25781 m
1 .25781 L
s
P
p
0 0 .5 r
.001 w
0 .26416 m
1 .26416 L
s
P
p
0 0 .5 r
.001 w
0 .26977 m
1 .26977 L
s
P
p
0 0 .5 r
.001 w
0 .30774 m
1 .30774 L
s
P
p
0 0 .5 r
.001 w
0 .32703 m
1 .32703 L
s
P
p
0 0 .5 r
.001 w
0 .34071 m
1 .34071 L
s
P
p
0 0 .5 r
.001 w
0 .35132 m
1 .35132 L
s
P
p
0 0 .5 r
.001 w
0 .36 m
1 .36 L
s
P
p
0 0 .5 r
.001 w
0 .36733 m
1 .36733 L
s
P
p
0 0 .5 r
.001 w
0 .37368 m
1 .37368 L
s
P
p
0 0 .5 r
.001 w
0 .37928 m
1 .37928 L
s
P
p
0 0 .5 r
.001 w
0 .41726 m
1 .41726 L
s
P
p
0 0 .5 r
.001 w
0 .43654 m
1 .43654 L
s
P
p
0 0 .5 r
.001 w
0 .45022 m
1 .45022 L
s
P
p
0 0 .5 r
.001 w
0 .46084 m
1 .46084 L
s
P
p
0 0 .5 r
.001 w
0 .46951 m
1 .46951 L
s
P
p
0 0 .5 r
.001 w
0 .47684 m
1 .47684 L
s
P
p
0 0 .5 r
.001 w
0 .48319 m
1 .48319 L
s
P
p
0 0 .5 r
.001 w
0 .48879 m
1 .48879 L
s
P
p
0 0 .5 r
.001 w
0 .52677 m
1 .52677 L
s
P
p
0 0 .5 r
.001 w
0 .54606 m
1 .54606 L
s
P
p
0 0 .5 r
.001 w
0 .55974 m
1 .55974 L
s
P
p
0 0 .5 r
.001 w
0 .57035 m
1 .57035 L
s
P
p
0 0 .5 r
.001 w
0 .57902 m
1 .57902 L
s
P
p
0 0 .5 r
.001 w
0 .58635 m
1 .58635 L
s
P
p
0 0 .5 r
.001 w
0 .59271 m
1 .59271 L
s
P
p
0 0 .5 r
.001 w
0 .59831 m
1 .59831 L
s
P
p
.002 w
.02381 0 m
.02381 .00625 L
s
P
[(0)] .02381 0 0 2 0 Minner Mrotshowa
p
.002 w
.22058 0 m
.22058 .00625 L
s
P
[(50)] .22058 0 0 2 0 Minner Mrotshowa
p
.002 w
.41736 0 m
.41736 .00625 L
s
P
[(100)] .41736 0 0 2 0 Minner Mrotshowa
p
.002 w
.61413 0 m
.61413 .00625 L
s
P
[(150)] .61413 0 0 2 0 Minner Mrotshowa
p
.002 w
.8109 0 m
.8109 .00625 L
s
P
[(200)] .8109 0 0 2 0 Minner Mrotshowa
p
.001 w
.06316 0 m
.06316 .00375 L
s
P
p
.001 w
.10252 0 m
.10252 .00375 L
s
P
p
.001 w
.14187 0 m
.14187 .00375 L
s
P
p
.001 w
.18123 0 m
.18123 .00375 L
s
P
p
.001 w
.25994 0 m
.25994 .00375 L
s
P
p
.001 w
.29929 0 m
.29929 .00375 L
s
P
p
.001 w
.33865 0 m
.33865 .00375 L
s
P
p
.001 w
.378 0 m
.378 .00375 L
s
P
p
.001 w
.45671 0 m
.45671 .00375 L
s
P
p
.001 w
.49606 0 m
.49606 .00375 L
s
P
p
.001 w
.53542 0 m
.53542 .00375 L
s
P
p
.001 w
.57477 0 m
.57477 .00375 L
s
P
p
.001 w
.65348 0 m
.65348 .00375 L
s
P
p
.001 w
.69284 0 m
.69284 .00375 L
s
P
p
.001 w
.73219 0 m
.73219 .00375 L
s
P
p
.001 w
.77155 0 m
.77155 .00375 L
s
P
p
.001 w
.85026 0 m
.85026 .00375 L
s
P
p
.001 w
.88961 0 m
.88961 .00375 L
s
P
p
.001 w
.92896 0 m
.92896 .00375 L
s
P
p
.001 w
.96832 0 m
.96832 .00375 L
s
P
[(Contents Reg1 {a:x^a mod n = 4})] .5 0 0 2 0 0 -1 Mouter Mrotshowa
p
.002 w
0 0 m
1 0 L
s
P
p
.002 w
0 .05575 m
.00625 .05575 L
s
P
[(0.00001)] -0.0125 .05575 1 0 0 Minner Mrotshowa
p
.002 w
0 .16526 m
.00625 .16526 L
s
P
[(0.0001)] -0.0125 .16526 1 0 0 Minner Mrotshowa
p
.002 w
0 .27478 m
.00625 .27478 L
s
P
[(0.001)] -0.0125 .27478 1 0 0 Minner Mrotshowa
p
.002 w
0 .38429 m
.00625 .38429 L
s
P
[(0.01)] -0.0125 .38429 1 0 0 Minner Mrotshowa
p
.002 w
0 .4938 m
.00625 .4938 L
s
P
[(0.1)] -0.0125 .4938 1 0 0 Minner Mrotshowa
p
.002 w
0 .60332 m
.00625 .60332 L
s
P
[(1)] -0.0125 .60332 1 0 0 Minner Mrotshowa
p
.001 w
0 .01217 m
.00375 .01217 L
s
P
p
.001 w
0 .02278 m
.00375 .02278 L
s
P
p
.001 w
0 .03145 m
.00375 .03145 L
s
P
p
.001 w
0 .03879 m
.00375 .03879 L
s
P
p
.001 w
0 .04514 m
.00375 .04514 L
s
P
p
.001 w
0 .05074 m
.00375 .05074 L
s
P
p
.001 w
0 .08872 m
.00375 .08872 L
s
P
p
.001 w
0 .108 m
.00375 .108 L
s
P
p
.001 w
0 .12168 m
.00375 .12168 L
s
P
p
.001 w
0 .1323 m
.00375 .1323 L
s
P
p
.001 w
0 .14097 m
.00375 .14097 L
s
P
p
.001 w
0 .1483 m
.00375 .1483 L
s
P
p
.001 w
0 .15465 m
.00375 .15465 L
s
P
p
.001 w
0 .16025 m
.00375 .16025 L
s
P
p
.001 w
0 .19823 m
.00375 .19823 L
s
P
p
.001 w
0 .21751 m
.00375 .21751 L
s
P
p
.001 w
0 .2312 m
.00375 .2312 L
s
P
p
.001 w
0 .24181 m
.00375 .24181 L
s
P
p
.001 w
0 .25048 m
.00375 .25048 L
s
P
p
.001 w
0 .25781 m
.00375 .25781 L
s
P
p
.001 w
0 .26416 m
.00375 .26416 L
s
P
p
.001 w
0 .26977 m
.00375 .26977 L
s
P
p
.001 w
0 .30774 m
.00375 .30774 L
s
P
p
.001 w
0 .32703 m
.00375 .32703 L
s
P
p
.001 w
0 .34071 m
.00375 .34071 L
s
P
p
.001 w
0 .35132 m
.00375 .35132 L
s
P
p
.001 w
0 .36 m
.00375 .36 L
s
P
p
.001 w
0 .36733 m
.00375 .36733 L
s
P
p
.001 w
0 .37368 m
.00375 .37368 L
s
P
p
.001 w
0 .37928 m
.00375 .37928 L
s
P
p
.001 w
0 .41726 m
.00375 .41726 L
s
P
p
.001 w
0 .43654 m
.00375 .43654 L
s
P
p
.001 w
0 .45022 m
.00375 .45022 L
s
P
p
.001 w
0 .46084 m
.00375 .46084 L
s
P
p
.001 w
0 .46951 m
.00375 .46951 L
s
P
p
.001 w
0 .47684 m
.00375 .47684 L
s
P
p
.001 w
0 .48319 m
.00375 .48319 L
s
P
p
.001 w
0 .48879 m
.00375 .48879 L
s
P
p
.001 w
0 .52677 m
.00375 .52677 L
s
P
p
.001 w
0 .54606 m
.00375 .54606 L
s
P
p
.001 w
0 .55974 m
.00375 .55974 L
s
P
p
.001 w
0 .57035 m
.00375 .57035 L
s
P
p
.001 w
0 .57902 m
.00375 .57902 L
s
P
p
.001 w
0 .58635 m
.00375 .58635 L
s
P
p
.001 w
0 .59271 m
.00375 .59271 L
s
P
p
.001 w
0 .59831 m
.00375 .59831 L
s
P
[(ln\(Pr\(Measure a\)\))] -0.0125 .30902 1 0 90 -1 0 Mouter Mrotshowa
p
.002 w
0 0 m
0 .61803 L
s
P
P
p
p
.002 w
.02381 .61178 m
.02381 .61803 L
s
P
p
.002 w
.22058 .61178 m
.22058 .61803 L
s
P
p
.002 w
.41736 .61178 m
.41736 .61803 L
s
P
p
.002 w
.61413 .61178 m
.61413 .61803 L
s
P
p
.002 w
.8109 .61178 m
.8109 .61803 L
s
P
p
.001 w
.06316 .61428 m
.06316 .61803 L
s
P
p
.001 w
.10252 .61428 m
.10252 .61803 L
s
P
p
.001 w
.14187 .61428 m
.14187 .61803 L
s
P
p
.001 w
.18123 .61428 m
.18123 .61803 L
s
P
p
.001 w
.25994 .61428 m
.25994 .61803 L
s
P
p
.001 w
.29929 .61428 m
.29929 .61803 L
s
P
p
.001 w
.33865 .61428 m
.33865 .61803 L
s
P
p
.001 w
.378 .61428 m
.378 .61803 L
s
P
p
.001 w
.45671 .61428 m
.45671 .61803 L
s
P
p
.001 w
.49606 .61428 m
.49606 .61803 L
s
P
p
.001 w
.53542 .61428 m
.53542 .61803 L
s
P
p
.001 w
.57477 .61428 m
.57477 .61803 L
s
P
p
.001 w
.65348 .61428 m
.65348 .61803 L
s
P
p
.001 w
.69284 .61428 m
.69284 .61803 L
s
P
p
.001 w
.73219 .61428 m
.73219 .61803 L
s
P
p
.001 w
.77155 .61428 m
.77155 .61803 L
s
P
p
.001 w
.85026 .61428 m
.85026 .61803 L
s
P
p
.001 w
.88961 .61428 m
.88961 .61803 L
s
P
p
.001 w
.92896 .61428 m
.92896 .61803 L
s
P
p
.001 w
.96832 .61428 m
.96832 .61803 L
s
P
p
.002 w
0 .61803 m
1 .61803 L
s
P
[(Compute Discrete Fourier Transform of Reg1)] .5 .61803 0 -2 Mshowa
p
.002 w
.99375 .05575 m
1 .05575 L
s
P
p
.002 w
.99375 .16526 m
1 .16526 L
s
P
p
.002 w
.99375 .27478 m
1 .27478 L
s
P
p
.002 w
.99375 .38429 m
1 .38429 L
s
P
p
.002 w
.99375 .4938 m
1 .4938 L
s
P
p
.002 w
.99375 .60332 m
1 .60332 L
s
P
p
.001 w
.99625 .01217 m
1 .01217 L
s
P
p
.001 w
.99625 .02278 m
1 .02278 L
s
P
p
.001 w
.99625 .03145 m
1 .03145 L
s
P
p
.001 w
.99625 .03879 m
1 .03879 L
s
P
p
.001 w
.99625 .04514 m
1 .04514 L
s
P
p
.001 w
.99625 .05074 m
1 .05074 L
s
P
p
.001 w
.99625 .08872 m
1 .08872 L
s
P
p
.001 w
.99625 .108 m
1 .108 L
s
P
p
.001 w
.99625 .12168 m
1 .12168 L
s
P
p
.001 w
.99625 .1323 m
1 .1323 L
s
P
p
.001 w
.99625 .14097 m
1 .14097 L
s
P
p
.001 w
.99625 .1483 m
1 .1483 L
s
P
p
.001 w
.99625 .15465 m
1 .15465 L
s
P
p
.001 w
.99625 .16025 m
1 .16025 L
s
P
p
.001 w
.99625 .19823 m
1 .19823 L
s
P
p
.001 w
.99625 .21751 m
1 .21751 L
s
P
p
.001 w
.99625 .2312 m
1 .2312 L
s
P
p
.001 w
.99625 .24181 m
1 .24181 L
s
P
p
.001 w
.99625 .25048 m
1 .25048 L
s
P
p
.001 w
.99625 .25781 m
1 .25781 L
s
P
p
.001 w
.99625 .26416 m
1 .26416 L
s
P
p
.001 w
.99625 .26977 m
1 .26977 L
s
P
p
.001 w
.99625 .30774 m
1 .30774 L
s
P
p
.001 w
.99625 .32703 m
1 .32703 L
s
P
p
.001 w
.99625 .34071 m
1 .34071 L
s
P
p
.001 w
.99625 .35132 m
1 .35132 L
s
P
p
.001 w
.99625 .36 m
1 .36 L
s
P
p
.001 w
.99625 .36733 m
1 .36733 L
s
P
p
.001 w
.99625 .37368 m
1 .37368 L
s
P
p
.001 w
.99625 .37928 m
1 .37928 L
s
P
p
.001 w
.99625 .41726 m
1 .41726 L
s
P
p
.001 w
.99625 .43654 m
1 .43654 L
s
P
p
.001 w
.99625 .45022 m
1 .45022 L
s
P
p
.001 w
.99625 .46084 m
1 .46084 L
s
P
p
.001 w
.99625 .46951 m
1 .46951 L
s
P
p
.001 w
.99625 .47684 m
1 .47684 L
s
P
p
.001 w
.99625 .48319 m
1 .48319 L
s
P
p
.001 w
.99625 .48879 m
1 .48879 L
s
P
p
.001 w
.99625 .52677 m
1 .52677 L
s
P
p
.001 w
.99625 .54606 m
1 .54606 L
s
P
p
.001 w
.99625 .55974 m
1 .55974 L
s
P
p
.001 w
.99625 .57035 m
1 .57035 L
s
P
p
.001 w
.99625 .57902 m
1 .57902 L
s
P
p
.001 w
.99625 .58635 m
1 .58635 L
s
P
p
.001 w
.99625 .59271 m
1 .59271 L
s
P
p
.001 w
.99625 .59831 m
1 .59831 L
s
P
p
.002 w
1 0 m
1 .61803 L
s
P
P
p
P
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
p
p
p
.01 w
.02381 .53758 Mdot
.02774 .01472 Mdot
.03168 .01483 Mdot
.03562 .01503 Mdot
.03955 .01531 Mdot
.04349 .01567 Mdot
.04742 .01611 Mdot
.05136 .01663 Mdot
.05529 .01723 Mdot
.05923 .01792 Mdot
.06316 .01869 Mdot
.0671 .01954 Mdot
.07104 .02048 Mdot
.07497 .0215 Mdot
.07891 .02262 Mdot
.08284 .02382 Mdot
.08678 .02511 Mdot
.09071 .02649 Mdot
.09465 .02797 Mdot
.09858 .02955 Mdot
.10252 .03122 Mdot
.10645 .033 Mdot
.11039 .03488 Mdot
.11433 .03686 Mdot
.11826 .03896 Mdot
.1222 .04117 Mdot
.12613 .04349 Mdot
.13007 .04594 Mdot
.134 .04852 Mdot
.13794 .05123 Mdot
.14187 .05407 Mdot
.14581 .05706 Mdot
.14974 .0602 Mdot
.15368 .06349 Mdot
.15762 .06695 Mdot
.16155 .07059 Mdot
.16549 .07442 Mdot
.16942 .07844 Mdot
.17336 .08267 Mdot
.17729 .08713 Mdot
.18123 .09184 Mdot
.18516 .09681 Mdot
.1891 .10207 Mdot
.19303 .10764 Mdot
.19697 .11356 Mdot
.20091 .11987 Mdot
.20484 .1266 Mdot
.20878 .13382 Mdot
.21271 .14159 Mdot
.21665 .14998 Mdot
.22058 .15912 Mdot
.22452 .16913 Mdot
.22845 .18019 Mdot
.23239 .19255 Mdot
.23632 .20656 Mdot
.24026 .22273 Mdot
.2442 .24186 Mdot
.24813 .26536 Mdot
.25207 .29592 Mdot
.256 .34003 Mdot
.25994 .42179 Mdot
.26387 .52751 Mdot
.26781 .37569 Mdot
.27174 .3211 Mdot
.27568 .2875 Mdot
.27961 .26341 Mdot
.28355 .24481 Mdot
.28749 .22977 Mdot
.29142 .21726 Mdot
.29536 .20664 Mdot
.29929 .19749 Mdot
.30323 .18952 Mdot
.30716 .18252 Mdot
.3111 .17635 Mdot
.31503 .17088 Mdot
.31897 .16602 Mdot
.3229 .1617 Mdot
.32684 .15787 Mdot
.33078 .15447 Mdot
.33471 .15147 Mdot
.33865 .14884 Mdot
.34258 .14654 Mdot
.34652 .14457 Mdot
.35045 .14289 Mdot
.35439 .14151 Mdot
.35832 .14039 Mdot
.36226 .13953 Mdot
.36619 .13893 Mdot
.37013 .13858 Mdot
.37407 .13846 Mdot
.378 .13859 Mdot
.38194 .13895 Mdot
.38587 .13955 Mdot
.38981 .14038 Mdot
.39374 .14146 Mdot
.39768 .14277 Mdot
.40161 .14433 Mdot
.40555 .14615 Mdot
.40948 .14823 Mdot
.41342 .15058 Mdot
.41736 .15321 Mdot
.42129 .15615 Mdot
.42523 .1594 Mdot
.42916 .16299 Mdot
.4331 .16694 Mdot
.43703 .17129 Mdot
.44097 .17607 Mdot
.4449 .18133 Mdot
.44884 .18713 Mdot
.45277 .19352 Mdot
.45671 .2006 Mdot
.46065 .20847 Mdot
.46458 .21729 Mdot
.46852 .22724 Mdot
.47245 .23859 Mdot
.47639 .25171 Mdot
.48032 .26719 Mdot
.48426 .28593 Mdot
.48819 .30956 Mdot
.49213 .34136 Mdot
.49606 .38981 Mdot
.5 .49424 Mdot
.50394 .49424 Mdot
.50787 .38981 Mdot
.51181 .34136 Mdot
.51574 .30956 Mdot
.51968 .28593 Mdot
.52361 .26719 Mdot
.52755 .25171 Mdot
.53148 .23859 Mdot
.53542 .22724 Mdot
.53935 .21729 Mdot
.54329 .20847 Mdot
.54723 .2006 Mdot
.55116 .19352 Mdot
.5551 .18713 Mdot
.55903 .18133 Mdot
.56297 .17607 Mdot
.5669 .17129 Mdot
.57084 .16694 Mdot
.57477 .16299 Mdot
.57871 .1594 Mdot
.58264 .15615 Mdot
.58658 .15321 Mdot
.59052 .15058 Mdot
.59445 .14823 Mdot
.59839 .14615 Mdot
.60232 .14433 Mdot
.60626 .14277 Mdot
.61019 .14146 Mdot
.61413 .14038 Mdot
.61806 .13955 Mdot
.622 .13895 Mdot
.62593 .13859 Mdot
.62987 .13846 Mdot
.63381 .13858 Mdot
.63774 .13893 Mdot
.64168 .13953 Mdot
.64561 .14039 Mdot
.64955 .14151 Mdot
.65348 .14289 Mdot
.65742 .14457 Mdot
.66135 .14654 Mdot
.66529 .14884 Mdot
.66922 .15147 Mdot
.67316 .15447 Mdot
.6771 .15787 Mdot
.68103 .1617 Mdot
.68497 .16602 Mdot
.6889 .17088 Mdot
.69284 .17635 Mdot
.69677 .18252 Mdot
.70071 .18952 Mdot
.70464 .19749 Mdot
.70858 .20664 Mdot
.71251 .21726 Mdot
.71645 .22977 Mdot
.72039 .24481 Mdot
.72432 .26341 Mdot
.72826 .2875 Mdot
.73219 .3211 Mdot
.73613 .37569 Mdot
.74006 .52751 Mdot
.744 .42179 Mdot
.74793 .34003 Mdot
.75187 .29592 Mdot
.7558 .26536 Mdot
.75974 .24186 Mdot
.76368 .22273 Mdot
.76761 .20656 Mdot
.77155 .19255 Mdot
.77548 .18019 Mdot
.77942 .16913 Mdot
.78335 .15912 Mdot
.78729 .14998 Mdot
.79122 .14159 Mdot
.79516 .13382 Mdot
.79909 .1266 Mdot
.80303 .11987 Mdot
.80697 .11356 Mdot
.8109 .10764 Mdot
.81484 .10207 Mdot
.81877 .09681 Mdot
.82271 .09184 Mdot
.82664 .08713 Mdot
.83058 .08267 Mdot
.83451 .07844 Mdot
.83845 .07442 Mdot
.84238 .07059 Mdot
.84632 .06695 Mdot
.85026 .06349 Mdot
.85419 .0602 Mdot
.85813 .05706 Mdot
.86206 .05407 Mdot
.866 .05123 Mdot
.86993 .04852 Mdot
.87387 .04594 Mdot
.8778 .04349 Mdot
.88174 .04117 Mdot
.88567 .03896 Mdot
.88961 .03686 Mdot
.89355 .03488 Mdot
.89748 .033 Mdot
.90142 .03122 Mdot
.90535 .02955 Mdot
.90929 .02797 Mdot
.91322 .02649 Mdot
.91716 .02511 Mdot
.92109 .02382 Mdot
.92503 .02262 Mdot
.92896 .0215 Mdot
.9329 .02048 Mdot
.93684 .01954 Mdot
.94077 .01869 Mdot
.94471 .01792 Mdot
.94864 .01723 Mdot
.95258 .01663 Mdot
.95651 .01611 Mdot
.96045 .01567 Mdot
.96438 .01531 Mdot
.96832 .01503 Mdot
.97226 .01483 Mdot
.97619 .01472 Mdot
P
P
p
1 0 0 r
p
.035 w
.256 .01472 Mdot
P
P
P
% End of Graphics
MathPictureEnd

:[font = postscript; PostScript; formatAsPostScript; output; inactive; preserveAspect; pictureLeft = 34; pictureWidth = 282; pictureHeight = 174; endGroup]
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
%% Graphics
/Courier findfont 8  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.0147151 0.47619 [
[(Repeat Shors Algm O\(ln\(q\)\) times. )( Obtain samples from DFT in Reg1)] .5 .61803 0 -2 Msboxa
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
[(Repeat Shors Algm O\(ln\(q\)\) times. )( Obtain samples from DFT in Reg1)] .5 .61803 0 -2 Mshowa
P
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
p
p
% Start of sub-graphic
p
0.0238095 0.0147151 0.477324 0.295003 MathSubStart
%% Graphics
/Courier findfont 8  scalefont  setfont
% Scaling calculations
0.0238095 0.00393546 0.603319 0.109514 [
[(0)] .02381 0 0 2 Msboxa
[(50)] .22058 0 0 2 Msboxa
[(100)] .41736 0 0 2 Msboxa
[(150)] .61413 0 0 2 Msboxa
[(200)] .8109 0 0 2 Msboxa
[(0.00001)] -0.0125 .05575 1 0 Msboxa
[(0.0001)] -0.0125 .16526 1 0 Msboxa
[(0.001)] -0.0125 .27478 1 0 Msboxa
[(0.01)] -0.0125 .38429 1 0 Msboxa
[(0.1)] -0.0125 .4938 1 0 Msboxa
[(1)] -0.0125 .60332 1 0 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 .61903 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
p
p
.002 w
.02381 0 m
.02381 .00625 L
s
P
[(0)] .02381 0 0 2 Mshowa
p
.002 w
.22058 0 m
.22058 .00625 L
s
P
[(50)] .22058 0 0 2 Mshowa
p
.002 w
.41736 0 m
.41736 .00625 L
s
P
[(100)] .41736 0 0 2 Mshowa
p
.002 w
.61413 0 m
.61413 .00625 L
s
P
[(150)] .61413 0 0 2 Mshowa
p
.002 w
.8109 0 m
.8109 .00625 L
s
P
[(200)] .8109 0 0 2 Mshowa
p
.001 w
.06316 0 m
.06316 .00375 L
s
P
p
.001 w
.10252 0 m
.10252 .00375 L
s
P
p
.001 w
.14187 0 m
.14187 .00375 L
s
P
p
.001 w
.18123 0 m
.18123 .00375 L
s
P
p
.001 w
.25994 0 m
.25994 .00375 L
s
P
p
.001 w
.29929 0 m
.29929 .00375 L
s
P
p
.001 w
.33865 0 m
.33865 .00375 L
s
P
p
.001 w
.378 0 m
.378 .00375 L
s
P
p
.001 w
.45671 0 m
.45671 .00375 L
s
P
p
.001 w
.49606 0 m
.49606 .00375 L
s
P
p
.001 w
.53542 0 m
.53542 .00375 L
s
P
p
.001 w
.57477 0 m
.57477 .00375 L
s
P
p
.001 w
.65348 0 m
.65348 .00375 L
s
P
p
.001 w
.69284 0 m
.69284 .00375 L
s
P
p
.001 w
.73219 0 m
.73219 .00375 L
s
P
p
.001 w
.77155 0 m
.77155 .00375 L
s
P
p
.001 w
.85026 0 m
.85026 .00375 L
s
P
p
.001 w
.88961 0 m
.88961 .00375 L
s
P
p
.001 w
.92896 0 m
.92896 .00375 L
s
P
p
.001 w
.96832 0 m
.96832 .00375 L
s
P
p
.002 w
0 0 m
1 0 L
s
P
p
.002 w
0 .05575 m
.00625 .05575 L
s
P
[(0.00001)] -0.0125 .05575 1 0 Mshowa
p
.002 w
0 .16526 m
.00625 .16526 L
s
P
[(0.0001)] -0.0125 .16526 1 0 Mshowa
p
.002 w
0 .27478 m
.00625 .27478 L
s
P
[(0.001)] -0.0125 .27478 1 0 Mshowa
p
.002 w
0 .38429 m
.00625 .38429 L
s
P
[(0.01)] -0.0125 .38429 1 0 Mshowa
p
.002 w
0 .4938 m
.00625 .4938 L
s
P
[(0.1)] -0.0125 .4938 1 0 Mshowa
p
.002 w
0 .60332 m
.00625 .60332 L
s
P
[(1)] -0.0125 .60332 1 0 Mshowa
p
.001 w
0 .01217 m
.00375 .01217 L
s
P
p
.001 w
0 .02278 m
.00375 .02278 L
s
P
p
.001 w
0 .03145 m
.00375 .03145 L
s
P
p
.001 w
0 .03879 m
.00375 .03879 L
s
P
p
.001 w
0 .04514 m
.00375 .04514 L
s
P
p
.001 w
0 .05074 m
.00375 .05074 L
s
P
p
.001 w
0 .08872 m
.00375 .08872 L
s
P
p
.001 w
0 .108 m
.00375 .108 L
s
P
p
.001 w
0 .12168 m
.00375 .12168 L
s
P
p
.001 w
0 .1323 m
.00375 .1323 L
s
P
p
.001 w
0 .14097 m
.00375 .14097 L
s
P
p
.001 w
0 .1483 m
.00375 .1483 L
s
P
p
.001 w
0 .15465 m
.00375 .15465 L
s
P
p
.001 w
0 .16025 m
.00375 .16025 L
s
P
p
.001 w
0 .19823 m
.00375 .19823 L
s
P
p
.001 w
0 .21751 m
.00375 .21751 L
s
P
p
.001 w
0 .2312 m
.00375 .2312 L
s
P
p
.001 w
0 .24181 m
.00375 .24181 L
s
P
p
.001 w
0 .25048 m
.00375 .25048 L
s
P
p
.001 w
0 .25781 m
.00375 .25781 L
s
P
p
.001 w
0 .26416 m
.00375 .26416 L
s
P
p
.001 w
0 .26977 m
.00375 .26977 L
s
P
p
.001 w
0 .30774 m
.00375 .30774 L
s
P
p
.001 w
0 .32703 m
.00375 .32703 L
s
P
p
.001 w
0 .34071 m
.00375 .34071 L
s
P
p
.001 w
0 .35132 m
.00375 .35132 L
s
P
p
.001 w
0 .36 m
.00375 .36 L
s
P
p
.001 w
0 .36733 m
.00375 .36733 L
s
P
p
.001 w
0 .37368 m
.00375 .37368 L
s
P
p
.001 w
0 .37928 m
.00375 .37928 L
s
P
p
.001 w
0 .41726 m
.00375 .41726 L
s
P
p
.001 w
0 .43654 m
.00375 .43654 L
s
P
p
.001 w
0 .45022 m
.00375 .45022 L
s
P
p
.001 w
0 .46084 m
.00375 .46084 L
s
P
p
.001 w
0 .46951 m
.00375 .46951 L
s
P
p
.001 w
0 .47684 m
.00375 .47684 L
s
P
p
.001 w
0 .48319 m
.00375 .48319 L
s
P
p
.001 w
0 .48879 m
.00375 .48879 L
s
P
p
.001 w
0 .52677 m
.00375 .52677 L
s
P
p
.001 w
0 .54606 m
.00375 .54606 L
s
P
p
.001 w
0 .55974 m
.00375 .55974 L
s
P
p
.001 w
0 .57035 m
.00375 .57035 L
s
P
p
.001 w
0 .57902 m
.00375 .57902 L
s
P
p
.001 w
0 .58635 m
.00375 .58635 L
s
P
p
.001 w
0 .59271 m
.00375 .59271 L
s
P
p
.001 w
0 .59831 m
.00375 .59831 L
s
P
p
.002 w
0 0 m
0 .61803 L
s
P
P
p
p
.002 w
.02381 .61178 m
.02381 .61803 L
s
P
p
.002 w
.22058 .61178 m
.22058 .61803 L
s
P
p
.002 w
.41736 .61178 m
.41736 .61803 L
s
P
p
.002 w
.61413 .61178 m
.61413 .61803 L
s
P
p
.002 w
.8109 .61178 m
.8109 .61803 L
s
P
p
.001 w
.06316 .61428 m
.06316 .61803 L
s
P
p
.001 w
.10252 .61428 m
.10252 .61803 L
s
P
p
.001 w
.14187 .61428 m
.14187 .61803 L
s
P
p
.001 w
.18123 .61428 m
.18123 .61803 L
s
P
p
.001 w
.25994 .61428 m
.25994 .61803 L
s
P
p
.001 w
.29929 .61428 m
.29929 .61803 L
s
P
p
.001 w
.33865 .61428 m
.33865 .61803 L
s
P
p
.001 w
.378 .61428 m
.378 .61803 L
s
P
p
.001 w
.45671 .61428 m
.45671 .61803 L
s
P
p
.001 w
.49606 .61428 m
.49606 .61803 L
s
P
p
.001 w
.53542 .61428 m
.53542 .61803 L
s
P
p
.001 w
.57477 .61428 m
.57477 .61803 L
s
P
p
.001 w
.65348 .61428 m
.65348 .61803 L
s
P
p
.001 w
.69284 .61428 m
.69284 .61803 L
s
P
p
.001 w
.73219 .61428 m
.73219 .61803 L
s
P
p
.001 w
.77155 .61428 m
.77155 .61803 L
s
P
p
.001 w
.85026 .61428 m
.85026 .61803 L
s
P
p
.001 w
.88961 .61428 m
.88961 .61803 L
s
P
p
.001 w
.92896 .61428 m
.92896 .61803 L
s
P
p
.001 w
.96832 .61428 m
.96832 .61803 L
s
P
p
.002 w
0 .61803 m
1 .61803 L
s
P
p
.002 w
.99375 .05575 m
1 .05575 L
s
P
p
.002 w
.99375 .16526 m
1 .16526 L
s
P
p
.002 w
.99375 .27478 m
1 .27478 L
s
P
p
.002 w
.99375 .38429 m
1 .38429 L
s
P
p
.002 w
.99375 .4938 m
1 .4938 L
s
P
p
.002 w
.99375 .60332 m
1 .60332 L
s
P
p
.001 w
.99625 .01217 m
1 .01217 L
s
P
p
.001 w
.99625 .02278 m
1 .02278 L
s
P
p
.001 w
.99625 .03145 m
1 .03145 L
s
P
p
.001 w
.99625 .03879 m
1 .03879 L
s
P
p
.001 w
.99625 .04514 m
1 .04514 L
s
P
p
.001 w
.99625 .05074 m
1 .05074 L
s
P
p
.001 w
.99625 .08872 m
1 .08872 L
s
P
p
.001 w
.99625 .108 m
1 .108 L
s
P
p
.001 w
.99625 .12168 m
1 .12168 L
s
P
p
.001 w
.99625 .1323 m
1 .1323 L
s
P
p
.001 w
.99625 .14097 m
1 .14097 L
s
P
p
.001 w
.99625 .1483 m
1 .1483 L
s
P
p
.001 w
.99625 .15465 m
1 .15465 L
s
P
p
.001 w
.99625 .16025 m
1 .16025 L
s
P
p
.001 w
.99625 .19823 m
1 .19823 L
s
P
p
.001 w
.99625 .21751 m
1 .21751 L
s
P
p
.001 w
.99625 .2312 m
1 .2312 L
s
P
p
.001 w
.99625 .24181 m
1 .24181 L
s
P
p
.001 w
.99625 .25048 m
1 .25048 L
s
P
p
.001 w
.99625 .25781 m
1 .25781 L
s
P
p
.001 w
.99625 .26416 m
1 .26416 L
s
P
p
.001 w
.99625 .26977 m
1 .26977 L
s
P
p
.001 w
.99625 .30774 m
1 .30774 L
s
P
p
.001 w
.99625 .32703 m
1 .32703 L
s
P
p
.001 w
.99625 .34071 m
1 .34071 L
s
P
p
.001 w
.99625 .35132 m
1 .35132 L
s
P
p
.001 w
.99625 .36 m
1 .36 L
s
P
p
.001 w
.99625 .36733 m
1 .36733 L
s
P
p
.001 w
.99625 .37368 m
1 .37368 L
s
P
p
.001 w
.99625 .37928 m
1 .37928 L
s
P
p
.001 w
.99625 .41726 m
1 .41726 L
s
P
p
.001 w
.99625 .43654 m
1 .43654 L
s
P
p
.001 w
.99625 .45022 m
1 .45022 L
s
P
p
.001 w
.99625 .46084 m
1 .46084 L
s
P
p
.001 w
.99625 .46951 m
1 .46951 L
s
P
p
.001 w
.99625 .47684 m
1 .47684 L
s
P
p
.001 w
.99625 .48319 m
1 .48319 L
s
P
p
.001 w
.99625 .48879 m
1 .48879 L
s
P
p
.001 w
.99625 .52677 m
1 .52677 L
s
P
p
.001 w
.99625 .54606 m
1 .54606 L
s
P
p
.001 w
.99625 .55974 m
1 .55974 L
s
P
p
.001 w
.99625 .57035 m
1 .57035 L
s
P
p
.001 w
.99625 .57902 m
1 .57902 L
s
P
p
.001 w
.99625 .58635 m
1 .58635 L
s
P
p
.001 w
.99625 .59271 m
1 .59271 L
s
P
p
.001 w
.99625 .59831 m
1 .59831 L
s
P
p
.002 w
1 0 m
1 .61803 L
s
P
P
p
P
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
p
p
.6 g
p
.008 w
.02381 .53758 Mdot
.02774 .01472 Mdot
.03168 .01483 Mdot
.03562 .01503 Mdot
.03955 .01531 Mdot
.04349 .01567 Mdot
.04742 .01611 Mdot
.05136 .01663 Mdot
.05529 .01723 Mdot
.05923 .01792 Mdot
.06316 .01869 Mdot
.0671 .01954 Mdot
.07104 .02048 Mdot
.07497 .0215 Mdot
.07891 .02262 Mdot
.08284 .02382 Mdot
.08678 .02511 Mdot
.09071 .02649 Mdot
.09465 .02797 Mdot
.09858 .02955 Mdot
.10252 .03122 Mdot
.10645 .033 Mdot
.11039 .03488 Mdot
.11433 .03686 Mdot
.11826 .03896 Mdot
.1222 .04117 Mdot
.12613 .04349 Mdot
.13007 .04594 Mdot
.134 .04852 Mdot
.13794 .05123 Mdot
.14187 .05407 Mdot
.14581 .05706 Mdot
.14974 .0602 Mdot
.15368 .06349 Mdot
.15762 .06695 Mdot
.16155 .07059 Mdot
.16549 .07442 Mdot
.16942 .07844 Mdot
.17336 .08267 Mdot
.17729 .08713 Mdot
.18123 .09184 Mdot
.18516 .09681 Mdot
.1891 .10207 Mdot
.19303 .10764 Mdot
.19697 .11356 Mdot
.20091 .11987 Mdot
.20484 .1266 Mdot
.20878 .13382 Mdot
.21271 .14159 Mdot
.21665 .14998 Mdot
.22058 .15912 Mdot
.22452 .16913 Mdot
.22845 .18019 Mdot
.23239 .19255 Mdot
.23632 .20656 Mdot
.24026 .22273 Mdot
.2442 .24186 Mdot
.24813 .26536 Mdot
.25207 .29592 Mdot
.256 .34003 Mdot
.25994 .42179 Mdot
.26387 .52751 Mdot
.26781 .37569 Mdot
.27174 .3211 Mdot
.27568 .2875 Mdot
.27961 .26341 Mdot
.28355 .24481 Mdot
.28749 .22977 Mdot
.29142 .21726 Mdot
.29536 .20664 Mdot
.29929 .19749 Mdot
.30323 .18952 Mdot
.30716 .18252 Mdot
.3111 .17635 Mdot
.31503 .17088 Mdot
.31897 .16602 Mdot
.3229 .1617 Mdot
.32684 .15787 Mdot
.33078 .15447 Mdot
.33471 .15147 Mdot
.33865 .14884 Mdot
.34258 .14654 Mdot
.34652 .14457 Mdot
.35045 .14289 Mdot
.35439 .14151 Mdot
.35832 .14039 Mdot
.36226 .13953 Mdot
.36619 .13893 Mdot
.37013 .13858 Mdot
.37407 .13846 Mdot
.378 .13859 Mdot
.38194 .13895 Mdot
.38587 .13955 Mdot
.38981 .14038 Mdot
.39374 .14146 Mdot
.39768 .14277 Mdot
.40161 .14433 Mdot
.40555 .14615 Mdot
.40948 .14823 Mdot
.41342 .15058 Mdot
.41736 .15321 Mdot
.42129 .15615 Mdot
.42523 .1594 Mdot
.42916 .16299 Mdot
.4331 .16694 Mdot
.43703 .17129 Mdot
.44097 .17607 Mdot
.4449 .18133 Mdot
.44884 .18713 Mdot
.45277 .19352 Mdot
.45671 .2006 Mdot
.46065 .20847 Mdot
.46458 .21729 Mdot
.46852 .22724 Mdot
.47245 .23859 Mdot
.47639 .25171 Mdot
.48032 .26719 Mdot
.48426 .28593 Mdot
.48819 .30956 Mdot
.49213 .34136 Mdot
.49606 .38981 Mdot
.5 .49424 Mdot
.50394 .49424 Mdot
.50787 .38981 Mdot
.51181 .34136 Mdot
.51574 .30956 Mdot
.51968 .28593 Mdot
.52361 .26719 Mdot
.52755 .25171 Mdot
.53148 .23859 Mdot
.53542 .22724 Mdot
.53935 .21729 Mdot
.54329 .20847 Mdot
.54723 .2006 Mdot
.55116 .19352 Mdot
.5551 .18713 Mdot
.55903 .18133 Mdot
.56297 .17607 Mdot
.5669 .17129 Mdot
.57084 .16694 Mdot
.57477 .16299 Mdot
.57871 .1594 Mdot
.58264 .15615 Mdot
.58658 .15321 Mdot
.59052 .15058 Mdot
.59445 .14823 Mdot
.59839 .14615 Mdot
.60232 .14433 Mdot
.60626 .14277 Mdot
.61019 .14146 Mdot
.61413 .14038 Mdot
.61806 .13955 Mdot
.622 .13895 Mdot
.62593 .13859 Mdot
.62987 .13846 Mdot
.63381 .13858 Mdot
.63774 .13893 Mdot
.64168 .13953 Mdot
.64561 .14039 Mdot
.64955 .14151 Mdot
.65348 .14289 Mdot
.65742 .14457 Mdot
.66135 .14654 Mdot
.66529 .14884 Mdot
.66922 .15147 Mdot
.67316 .15447 Mdot
.6771 .15787 Mdot
.68103 .1617 Mdot
.68497 .16602 Mdot
.6889 .17088 Mdot
.69284 .17635 Mdot
.69677 .18252 Mdot
.70071 .18952 Mdot
.70464 .19749 Mdot
.70858 .20664 Mdot
.71251 .21726 Mdot
.71645 .22977 Mdot
.72039 .24481 Mdot
.72432 .26341 Mdot
.72826 .2875 Mdot
.73219 .3211 Mdot
.73613 .37569 Mdot
.74006 .52751 Mdot
.744 .42179 Mdot
.74793 .34003 Mdot
.75187 .29592 Mdot
.7558 .26536 Mdot
.75974 .24186 Mdot
.76368 .22273 Mdot
.76761 .20656 Mdot
.77155 .19255 Mdot
.77548 .18019 Mdot
.77942 .16913 Mdot
.78335 .15912 Mdot
.78729 .14998 Mdot
.79122 .14159 Mdot
.79516 .13382 Mdot
.79909 .1266 Mdot
.80303 .11987 Mdot
.80697 .11356 Mdot
.8109 .10764 Mdot
.81484 .10207 Mdot
.81877 .09681 Mdot
.82271 .09184 Mdot
.82664 .08713 Mdot
.83058 .08267 Mdot
.83451 .07844 Mdot
.83845 .07442 Mdot
.84238 .07059 Mdot
.84632 .06695 Mdot
.85026 .06349 Mdot
.85419 .0602 Mdot
.85813 .05706 Mdot
.86206 .05407 Mdot
.866 .05123 Mdot
.86993 .04852 Mdot
.87387 .04594 Mdot
.8778 .04349 Mdot
.88174 .04117 Mdot
.88567 .03896 Mdot
.88961 .03686 Mdot
.89355 .03488 Mdot
.89748 .033 Mdot
.90142 .03122 Mdot
.90535 .02955 Mdot
.90929 .02797 Mdot
.91322 .02649 Mdot
.91716 .02511 Mdot
.92109 .02382 Mdot
.92503 .02262 Mdot
.92896 .0215 Mdot
.9329 .02048 Mdot
.93684 .01954 Mdot
.94077 .01869 Mdot
.94471 .01792 Mdot
.94864 .01723 Mdot
.95258 .01663 Mdot
.95651 .01611 Mdot
.96045 .01567 Mdot
.96438 .01531 Mdot
.96832 .01503 Mdot
.97226 .01483 Mdot
.97619 .01472 Mdot
P
P
p
1 0 0 r
p
.035 w
.5 .01472 Mdot
P
P
P
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.522676 0.0147151 0.97619 0.295003 MathSubStart
%% Graphics
/Courier findfont 8  scalefont  setfont
% Scaling calculations
0.0238095 0.00393546 0.603319 0.109514 [
[(0)] .02381 0 0 2 Msboxa
[(50)] .22058 0 0 2 Msboxa
[(100)] .41736 0 0 2 Msboxa
[(150)] .61413 0 0 2 Msboxa
[(200)] .8109 0 0 2 Msboxa
[(0.00001)] -0.0125 .05575 1 0 Msboxa
[(0.0001)] -0.0125 .16526 1 0 Msboxa
[(0.001)] -0.0125 .27478 1 0 Msboxa
[(0.01)] -0.0125 .38429 1 0 Msboxa
[(0.1)] -0.0125 .4938 1 0 Msboxa
[(1)] -0.0125 .60332 1 0 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 .61903 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
p
p
.002 w
.02381 0 m
.02381 .00625 L
s
P
[(0)] .02381 0 0 2 Mshowa
p
.002 w
.22058 0 m
.22058 .00625 L
s
P
[(50)] .22058 0 0 2 Mshowa
p
.002 w
.41736 0 m
.41736 .00625 L
s
P
[(100)] .41736 0 0 2 Mshowa
p
.002 w
.61413 0 m
.61413 .00625 L
s
P
[(150)] .61413 0 0 2 Mshowa
p
.002 w
.8109 0 m
.8109 .00625 L
s
P
[(200)] .8109 0 0 2 Mshowa
p
.001 w
.06316 0 m
.06316 .00375 L
s
P
p
.001 w
.10252 0 m
.10252 .00375 L
s
P
p
.001 w
.14187 0 m
.14187 .00375 L
s
P
p
.001 w
.18123 0 m
.18123 .00375 L
s
P
p
.001 w
.25994 0 m
.25994 .00375 L
s
P
p
.001 w
.29929 0 m
.29929 .00375 L
s
P
p
.001 w
.33865 0 m
.33865 .00375 L
s
P
p
.001 w
.378 0 m
.378 .00375 L
s
P
p
.001 w
.45671 0 m
.45671 .00375 L
s
P
p
.001 w
.49606 0 m
.49606 .00375 L
s
P
p
.001 w
.53542 0 m
.53542 .00375 L
s
P
p
.001 w
.57477 0 m
.57477 .00375 L
s
P
p
.001 w
.65348 0 m
.65348 .00375 L
s
P
p
.001 w
.69284 0 m
.69284 .00375 L
s
P
p
.001 w
.73219 0 m
.73219 .00375 L
s
P
p
.001 w
.77155 0 m
.77155 .00375 L
s
P
p
.001 w
.85026 0 m
.85026 .00375 L
s
P
p
.001 w
.88961 0 m
.88961 .00375 L
s
P
p
.001 w
.92896 0 m
.92896 .00375 L
s
P
p
.001 w
.96832 0 m
.96832 .00375 L
s
P
p
.002 w
0 0 m
1 0 L
s
P
p
.002 w
0 .05575 m
.00625 .05575 L
s
P
[(0.00001)] -0.0125 .05575 1 0 Mshowa
p
.002 w
0 .16526 m
.00625 .16526 L
s
P
[(0.0001)] -0.0125 .16526 1 0 Mshowa
p
.002 w
0 .27478 m
.00625 .27478 L
s
P
[(0.001)] -0.0125 .27478 1 0 Mshowa
p
.002 w
0 .38429 m
.00625 .38429 L
s
P
[(0.01)] -0.0125 .38429 1 0 Mshowa
p
.002 w
0 .4938 m
.00625 .4938 L
s
P
[(0.1)] -0.0125 .4938 1 0 Mshowa
p
.002 w
0 .60332 m
.00625 .60332 L
s
P
[(1)] -0.0125 .60332 1 0 Mshowa
p
.001 w
0 .01217 m
.00375 .01217 L
s
P
p
.001 w
0 .02278 m
.00375 .02278 L
s
P
p
.001 w
0 .03145 m
.00375 .03145 L
s
P
p
.001 w
0 .03879 m
.00375 .03879 L
s
P
p
.001 w
0 .04514 m
.00375 .04514 L
s
P
p
.001 w
0 .05074 m
.00375 .05074 L
s
P
p
.001 w
0 .08872 m
.00375 .08872 L
s
P
p
.001 w
0 .108 m
.00375 .108 L
s
P
p
.001 w
0 .12168 m
.00375 .12168 L
s
P
p
.001 w
0 .1323 m
.00375 .1323 L
s
P
p
.001 w
0 .14097 m
.00375 .14097 L
s
P
p
.001 w
0 .1483 m
.00375 .1483 L
s
P
p
.001 w
0 .15465 m
.00375 .15465 L
s
P
p
.001 w
0 .16025 m
.00375 .16025 L
s
P
p
.001 w
0 .19823 m
.00375 .19823 L
s
P
p
.001 w
0 .21751 m
.00375 .21751 L
s
P
p
.001 w
0 .2312 m
.00375 .2312 L
s
P
p
.001 w
0 .24181 m
.00375 .24181 L
s
P
p
.001 w
0 .25048 m
.00375 .25048 L
s
P
p
.001 w
0 .25781 m
.00375 .25781 L
s
P
p
.001 w
0 .26416 m
.00375 .26416 L
s
P
p
.001 w
0 .26977 m
.00375 .26977 L
s
P
p
.001 w
0 .30774 m
.00375 .30774 L
s
P
p
.001 w
0 .32703 m
.00375 .32703 L
s
P
p
.001 w
0 .34071 m
.00375 .34071 L
s
P
p
.001 w
0 .35132 m
.00375 .35132 L
s
P
p
.001 w
0 .36 m
.00375 .36 L
s
P
p
.001 w
0 .36733 m
.00375 .36733 L
s
P
p
.001 w
0 .37368 m
.00375 .37368 L
s
P
p
.001 w
0 .37928 m
.00375 .37928 L
s
P
p
.001 w
0 .41726 m
.00375 .41726 L
s
P
p
.001 w
0 .43654 m
.00375 .43654 L
s
P
p
.001 w
0 .45022 m
.00375 .45022 L
s
P
p
.001 w
0 .46084 m
.00375 .46084 L
s
P
p
.001 w
0 .46951 m
.00375 .46951 L
s
P
p
.001 w
0 .47684 m
.00375 .47684 L
s
P
p
.001 w
0 .48319 m
.00375 .48319 L
s
P
p
.001 w
0 .48879 m
.00375 .48879 L
s
P
p
.001 w
0 .52677 m
.00375 .52677 L
s
P
p
.001 w
0 .54606 m
.00375 .54606 L
s
P
p
.001 w
0 .55974 m
.00375 .55974 L
s
P
p
.001 w
0 .57035 m
.00375 .57035 L
s
P
p
.001 w
0 .57902 m
.00375 .57902 L
s
P
p
.001 w
0 .58635 m
.00375 .58635 L
s
P
p
.001 w
0 .59271 m
.00375 .59271 L
s
P
p
.001 w
0 .59831 m
.00375 .59831 L
s
P
p
.002 w
0 0 m
0 .61803 L
s
P
P
p
p
.002 w
.02381 .61178 m
.02381 .61803 L
s
P
p
.002 w
.22058 .61178 m
.22058 .61803 L
s
P
p
.002 w
.41736 .61178 m
.41736 .61803 L
s
P
p
.002 w
.61413 .61178 m
.61413 .61803 L
s
P
p
.002 w
.8109 .61178 m
.8109 .61803 L
s
P
p
.001 w
.06316 .61428 m
.06316 .61803 L
s
P
p
.001 w
.10252 .61428 m
.10252 .61803 L
s
P
p
.001 w
.14187 .61428 m
.14187 .61803 L
s
P
p
.001 w
.18123 .61428 m
.18123 .61803 L
s
P
p
.001 w
.25994 .61428 m
.25994 .61803 L
s
P
p
.001 w
.29929 .61428 m
.29929 .61803 L
s
P
p
.001 w
.33865 .61428 m
.33865 .61803 L
s
P
p
.001 w
.378 .61428 m
.378 .61803 L
s
P
p
.001 w
.45671 .61428 m
.45671 .61803 L
s
P
p
.001 w
.49606 .61428 m
.49606 .61803 L
s
P
p
.001 w
.53542 .61428 m
.53542 .61803 L
s
P
p
.001 w
.57477 .61428 m
.57477 .61803 L
s
P
p
.001 w
.65348 .61428 m
.65348 .61803 L
s
P
p
.001 w
.69284 .61428 m
.69284 .61803 L
s
P
p
.001 w
.73219 .61428 m
.73219 .61803 L
s
P
p
.001 w
.77155 .61428 m
.77155 .61803 L
s
P
p
.001 w
.85026 .61428 m
.85026 .61803 L
s
P
p
.001 w
.88961 .61428 m
.88961 .61803 L
s
P
p
.001 w
.92896 .61428 m
.92896 .61803 L
s
P
p
.001 w
.96832 .61428 m
.96832 .61803 L
s
P
p
.002 w
0 .61803 m
1 .61803 L
s
P
p
.002 w
.99375 .05575 m
1 .05575 L
s
P
p
.002 w
.99375 .16526 m
1 .16526 L
s
P
p
.002 w
.99375 .27478 m
1 .27478 L
s
P
p
.002 w
.99375 .38429 m
1 .38429 L
s
P
p
.002 w
.99375 .4938 m
1 .4938 L
s
P
p
.002 w
.99375 .60332 m
1 .60332 L
s
P
p
.001 w
.99625 .01217 m
1 .01217 L
s
P
p
.001 w
.99625 .02278 m
1 .02278 L
s
P
p
.001 w
.99625 .03145 m
1 .03145 L
s
P
p
.001 w
.99625 .03879 m
1 .03879 L
s
P
p
.001 w
.99625 .04514 m
1 .04514 L
s
P
p
.001 w
.99625 .05074 m
1 .05074 L
s
P
p
.001 w
.99625 .08872 m
1 .08872 L
s
P
p
.001 w
.99625 .108 m
1 .108 L
s
P
p
.001 w
.99625 .12168 m
1 .12168 L
s
P
p
.001 w
.99625 .1323 m
1 .1323 L
s
P
p
.001 w
.99625 .14097 m
1 .14097 L
s
P
p
.001 w
.99625 .1483 m
1 .1483 L
s
P
p
.001 w
.99625 .15465 m
1 .15465 L
s
P
p
.001 w
.99625 .16025 m
1 .16025 L
s
P
p
.001 w
.99625 .19823 m
1 .19823 L
s
P
p
.001 w
.99625 .21751 m
1 .21751 L
s
P
p
.001 w
.99625 .2312 m
1 .2312 L
s
P
p
.001 w
.99625 .24181 m
1 .24181 L
s
P
p
.001 w
.99625 .25048 m
1 .25048 L
s
P
p
.001 w
.99625 .25781 m
1 .25781 L
s
P
p
.001 w
.99625 .26416 m
1 .26416 L
s
P
p
.001 w
.99625 .26977 m
1 .26977 L
s
P
p
.001 w
.99625 .30774 m
1 .30774 L
s
P
p
.001 w
.99625 .32703 m
1 .32703 L
s
P
p
.001 w
.99625 .34071 m
1 .34071 L
s
P
p
.001 w
.99625 .35132 m
1 .35132 L
s
P
p
.001 w
.99625 .36 m
1 .36 L
s
P
p
.001 w
.99625 .36733 m
1 .36733 L
s
P
p
.001 w
.99625 .37368 m
1 .37368 L
s
P
p
.001 w
.99625 .37928 m
1 .37928 L
s
P
p
.001 w
.99625 .41726 m
1 .41726 L
s
P
p
.001 w
.99625 .43654 m
1 .43654 L
s
P
p
.001 w
.99625 .45022 m
1 .45022 L
s
P
p
.001 w
.99625 .46084 m
1 .46084 L
s
P
p
.001 w
.99625 .46951 m
1 .46951 L
s
P
p
.001 w
.99625 .47684 m
1 .47684 L
s
P
p
.001 w
.99625 .48319 m
1 .48319 L
s
P
p
.001 w
.99625 .48879 m
1 .48879 L
s
P
p
.001 w
.99625 .52677 m
1 .52677 L
s
P
p
.001 w
.99625 .54606 m
1 .54606 L
s
P
p
.001 w
.99625 .55974 m
1 .55974 L
s
P
p
.001 w
.99625 .57035 m
1 .57035 L
s
P
p
.001 w
.99625 .57902 m
1 .57902 L
s
P
p
.001 w
.99625 .58635 m
1 .58635 L
s
P
p
.001 w
.99625 .59271 m
1 .59271 L
s
P
p
.001 w
.99625 .59831 m
1 .59831 L
s
P
p
.002 w
1 0 m
1 .61803 L
s
P
P
p
P
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
p
p
.6 g
p
.008 w
.02381 .53758 Mdot
.02774 .01472 Mdot
.03168 .01483 Mdot
.03562 .01503 Mdot
.03955 .01531 Mdot
.04349 .01567 Mdot
.04742 .01611 Mdot
.05136 .01663 Mdot
.05529 .01723 Mdot
.05923 .01792 Mdot
.06316 .01869 Mdot
.0671 .01954 Mdot
.07104 .02048 Mdot
.07497 .0215 Mdot
.07891 .02262 Mdot
.08284 .02382 Mdot
.08678 .02511 Mdot
.09071 .02649 Mdot
.09465 .02797 Mdot
.09858 .02955 Mdot
.10252 .03122 Mdot
.10645 .033 Mdot
.11039 .03488 Mdot
.11433 .03686 Mdot
.11826 .03896 Mdot
.1222 .04117 Mdot
.12613 .04349 Mdot
.13007 .04594 Mdot
.134 .04852 Mdot
.13794 .05123 Mdot
.14187 .05407 Mdot
.14581 .05706 Mdot
.14974 .0602 Mdot
.15368 .06349 Mdot
.15762 .06695 Mdot
.16155 .07059 Mdot
.16549 .07442 Mdot
.16942 .07844 Mdot
.17336 .08267 Mdot
.17729 .08713 Mdot
.18123 .09184 Mdot
.18516 .09681 Mdot
.1891 .10207 Mdot
.19303 .10764 Mdot
.19697 .11356 Mdot
.20091 .11987 Mdot
.20484 .1266 Mdot
.20878 .13382 Mdot
.21271 .14159 Mdot
.21665 .14998 Mdot
.22058 .15912 Mdot
.22452 .16913 Mdot
.22845 .18019 Mdot
.23239 .19255 Mdot
.23632 .20656 Mdot
.24026 .22273 Mdot
.2442 .24186 Mdot
.24813 .26536 Mdot
.25207 .29592 Mdot
.256 .34003 Mdot
.25994 .42179 Mdot
.26387 .52751 Mdot
.26781 .37569 Mdot
.27174 .3211 Mdot
.27568 .2875 Mdot
.27961 .26341 Mdot
.28355 .24481 Mdot
.28749 .22977 Mdot
.29142 .21726 Mdot
.29536 .20664 Mdot
.29929 .19749 Mdot
.30323 .18952 Mdot
.30716 .18252 Mdot
.3111 .17635 Mdot
.31503 .17088 Mdot
.31897 .16602 Mdot
.3229 .1617 Mdot
.32684 .15787 Mdot
.33078 .15447 Mdot
.33471 .15147 Mdot
.33865 .14884 Mdot
.34258 .14654 Mdot
.34652 .14457 Mdot
.35045 .14289 Mdot
.35439 .14151 Mdot
.35832 .14039 Mdot
.36226 .13953 Mdot
.36619 .13893 Mdot
.37013 .13858 Mdot
.37407 .13846 Mdot
.378 .13859 Mdot
.38194 .13895 Mdot
.38587 .13955 Mdot
.38981 .14038 Mdot
.39374 .14146 Mdot
.39768 .14277 Mdot
.40161 .14433 Mdot
.40555 .14615 Mdot
.40948 .14823 Mdot
.41342 .15058 Mdot
.41736 .15321 Mdot
.42129 .15615 Mdot
.42523 .1594 Mdot
.42916 .16299 Mdot
.4331 .16694 Mdot
.43703 .17129 Mdot
.44097 .17607 Mdot
.4449 .18133 Mdot
.44884 .18713 Mdot
.45277 .19352 Mdot
.45671 .2006 Mdot
.46065 .20847 Mdot
.46458 .21729 Mdot
.46852 .22724 Mdot
.47245 .23859 Mdot
.47639 .25171 Mdot
.48032 .26719 Mdot
.48426 .28593 Mdot
.48819 .30956 Mdot
.49213 .34136 Mdot
.49606 .38981 Mdot
.5 .49424 Mdot
.50394 .49424 Mdot
.50787 .38981 Mdot
.51181 .34136 Mdot
.51574 .30956 Mdot
.51968 .28593 Mdot
.52361 .26719 Mdot
.52755 .25171 Mdot
.53148 .23859 Mdot
.53542 .22724 Mdot
.53935 .21729 Mdot
.54329 .20847 Mdot
.54723 .2006 Mdot
.55116 .19352 Mdot
.5551 .18713 Mdot
.55903 .18133 Mdot
.56297 .17607 Mdot
.5669 .17129 Mdot
.57084 .16694 Mdot
.57477 .16299 Mdot
.57871 .1594 Mdot
.58264 .15615 Mdot
.58658 .15321 Mdot
.59052 .15058 Mdot
.59445 .14823 Mdot
.59839 .14615 Mdot
.60232 .14433 Mdot
.60626 .14277 Mdot
.61019 .14146 Mdot
.61413 .14038 Mdot
.61806 .13955 Mdot
.622 .13895 Mdot
.62593 .13859 Mdot
.62987 .13846 Mdot
.63381 .13858 Mdot
.63774 .13893 Mdot
.64168 .13953 Mdot
.64561 .14039 Mdot
.64955 .14151 Mdot
.65348 .14289 Mdot
.65742 .14457 Mdot
.66135 .14654 Mdot
.66529 .14884 Mdot
.66922 .15147 Mdot
.67316 .15447 Mdot
.6771 .15787 Mdot
.68103 .1617 Mdot
.68497 .16602 Mdot
.6889 .17088 Mdot
.69284 .17635 Mdot
.69677 .18252 Mdot
.70071 .18952 Mdot
.70464 .19749 Mdot
.70858 .20664 Mdot
.71251 .21726 Mdot
.71645 .22977 Mdot
.72039 .24481 Mdot
.72432 .26341 Mdot
.72826 .2875 Mdot
.73219 .3211 Mdot
.73613 .37569 Mdot
.74006 .52751 Mdot
.744 .42179 Mdot
.74793 .34003 Mdot
.75187 .29592 Mdot
.7558 .26536 Mdot
.75974 .24186 Mdot
.76368 .22273 Mdot
.76761 .20656 Mdot
.77155 .19255 Mdot
.77548 .18019 Mdot
.77942 .16913 Mdot
.78335 .15912 Mdot
.78729 .14998 Mdot
.79122 .14159 Mdot
.79516 .13382 Mdot
.79909 .1266 Mdot
.80303 .11987 Mdot
.80697 .11356 Mdot
.8109 .10764 Mdot
.81484 .10207 Mdot
.81877 .09681 Mdot
.82271 .09184 Mdot
.82664 .08713 Mdot
.83058 .08267 Mdot
.83451 .07844 Mdot
.83845 .07442 Mdot
.84238 .07059 Mdot
.84632 .06695 Mdot
.85026 .06349 Mdot
.85419 .0602 Mdot
.85813 .05706 Mdot
.86206 .05407 Mdot
.866 .05123 Mdot
.86993 .04852 Mdot
.87387 .04594 Mdot
.8778 .04349 Mdot
.88174 .04117 Mdot
.88567 .03896 Mdot
.88961 .03686 Mdot
.89355 .03488 Mdot
.89748 .033 Mdot
.90142 .03122 Mdot
.90535 .02955 Mdot
.90929 .02797 Mdot
.91322 .02649 Mdot
.91716 .02511 Mdot
.92109 .02382 Mdot
.92503 .02262 Mdot
.92896 .0215 Mdot
.9329 .02048 Mdot
.93684 .01954 Mdot
.94077 .01869 Mdot
.94471 .01792 Mdot
.94864 .01723 Mdot
.95258 .01663 Mdot
.95651 .01611 Mdot
.96045 .01567 Mdot
.96438 .01531 Mdot
.96832 .01503 Mdot
.97226 .01483 Mdot
.97619 .01472 Mdot
P
P
p
1 0 0 r
p
.035 w
.73613 .01472 Mdot
P
P
P
MathSubEnd
P
% End of sub-graphic
P
p
% Start of sub-graphic
p
0.0238095 0.323031 0.477324 0.603319 MathSubStart
%% Graphics
/Courier findfont 8  scalefont  setfont
% Scaling calculations
0.0238095 0.00393546 0.603319 0.109514 [
[(0)] .02381 0 0 2 Msboxa
[(50)] .22058 0 0 2 Msboxa
[(100)] .41736 0 0 2 Msboxa
[(150)] .61413 0 0 2 Msboxa
[(200)] .8109 0 0 2 Msboxa
[(0.00001)] -0.0125 .05575 1 0 Msboxa
[(0.0001)] -0.0125 .16526 1 0 Msboxa
[(0.001)] -0.0125 .27478 1 0 Msboxa
[(0.01)] -0.0125 .38429 1 0 Msboxa
[(0.1)] -0.0125 .4938 1 0 Msboxa
[(1)] -0.0125 .60332 1 0 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 .61903 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
p
p
.002 w
.02381 0 m
.02381 .00625 L
s
P
[(0)] .02381 0 0 2 Mshowa
p
.002 w
.22058 0 m
.22058 .00625 L
s
P
[(50)] .22058 0 0 2 Mshowa
p
.002 w
.41736 0 m
.41736 .00625 L
s
P
[(100)] .41736 0 0 2 Mshowa
p
.002 w
.61413 0 m
.61413 .00625 L
s
P
[(150)] .61413 0 0 2 Mshowa
p
.002 w
.8109 0 m
.8109 .00625 L
s
P
[(200)] .8109 0 0 2 Mshowa
p
.001 w
.06316 0 m
.06316 .00375 L
s
P
p
.001 w
.10252 0 m
.10252 .00375 L
s
P
p
.001 w
.14187 0 m
.14187 .00375 L
s
P
p
.001 w
.18123 0 m
.18123 .00375 L
s
P
p
.001 w
.25994 0 m
.25994 .00375 L
s
P
p
.001 w
.29929 0 m
.29929 .00375 L
s
P
p
.001 w
.33865 0 m
.33865 .00375 L
s
P
p
.001 w
.378 0 m
.378 .00375 L
s
P
p
.001 w
.45671 0 m
.45671 .00375 L
s
P
p
.001 w
.49606 0 m
.49606 .00375 L
s
P
p
.001 w
.53542 0 m
.53542 .00375 L
s
P
p
.001 w
.57477 0 m
.57477 .00375 L
s
P
p
.001 w
.65348 0 m
.65348 .00375 L
s
P
p
.001 w
.69284 0 m
.69284 .00375 L
s
P
p
.001 w
.73219 0 m
.73219 .00375 L
s
P
p
.001 w
.77155 0 m
.77155 .00375 L
s
P
p
.001 w
.85026 0 m
.85026 .00375 L
s
P
p
.001 w
.88961 0 m
.88961 .00375 L
s
P
p
.001 w
.92896 0 m
.92896 .00375 L
s
P
p
.001 w
.96832 0 m
.96832 .00375 L
s
P
p
.002 w
0 0 m
1 0 L
s
P
p
.002 w
0 .05575 m
.00625 .05575 L
s
P
[(0.00001)] -0.0125 .05575 1 0 Mshowa
p
.002 w
0 .16526 m
.00625 .16526 L
s
P
[(0.0001)] -0.0125 .16526 1 0 Mshowa
p
.002 w
0 .27478 m
.00625 .27478 L
s
P
[(0.001)] -0.0125 .27478 1 0 Mshowa
p
.002 w
0 .38429 m
.00625 .38429 L
s
P
[(0.01)] -0.0125 .38429 1 0 Mshowa
p
.002 w
0 .4938 m
.00625 .4938 L
s
P
[(0.1)] -0.0125 .4938 1 0 Mshowa
p
.002 w
0 .60332 m
.00625 .60332 L
s
P
[(1)] -0.0125 .60332 1 0 Mshowa
p
.001 w
0 .01217 m
.00375 .01217 L
s
P
p
.001 w
0 .02278 m
.00375 .02278 L
s
P
p
.001 w
0 .03145 m
.00375 .03145 L
s
P
p
.001 w
0 .03879 m
.00375 .03879 L
s
P
p
.001 w
0 .04514 m
.00375 .04514 L
s
P
p
.001 w
0 .05074 m
.00375 .05074 L
s
P
p
.001 w
0 .08872 m
.00375 .08872 L
s
P
p
.001 w
0 .108 m
.00375 .108 L
s
P
p
.001 w
0 .12168 m
.00375 .12168 L
s
P
p
.001 w
0 .1323 m
.00375 .1323 L
s
P
p
.001 w
0 .14097 m
.00375 .14097 L
s
P
p
.001 w
0 .1483 m
.00375 .1483 L
s
P
p
.001 w
0 .15465 m
.00375 .15465 L
s
P
p
.001 w
0 .16025 m
.00375 .16025 L
s
P
p
.001 w
0 .19823 m
.00375 .19823 L
s
P
p
.001 w
0 .21751 m
.00375 .21751 L
s
P
p
.001 w
0 .2312 m
.00375 .2312 L
s
P
p
.001 w
0 .24181 m
.00375 .24181 L
s
P
p
.001 w
0 .25048 m
.00375 .25048 L
s
P
p
.001 w
0 .25781 m
.00375 .25781 L
s
P
p
.001 w
0 .26416 m
.00375 .26416 L
s
P
p
.001 w
0 .26977 m
.00375 .26977 L
s
P
p
.001 w
0 .30774 m
.00375 .30774 L
s
P
p
.001 w
0 .32703 m
.00375 .32703 L
s
P
p
.001 w
0 .34071 m
.00375 .34071 L
s
P
p
.001 w
0 .35132 m
.00375 .35132 L
s
P
p
.001 w
0 .36 m
.00375 .36 L
s
P
p
.001 w
0 .36733 m
.00375 .36733 L
s
P
p
.001 w
0 .37368 m
.00375 .37368 L
s
P
p
.001 w
0 .37928 m
.00375 .37928 L
s
P
p
.001 w
0 .41726 m
.00375 .41726 L
s
P
p
.001 w
0 .43654 m
.00375 .43654 L
s
P
p
.001 w
0 .45022 m
.00375 .45022 L
s
P
p
.001 w
0 .46084 m
.00375 .46084 L
s
P
p
.001 w
0 .46951 m
.00375 .46951 L
s
P
p
.001 w
0 .47684 m
.00375 .47684 L
s
P
p
.001 w
0 .48319 m
.00375 .48319 L
s
P
p
.001 w
0 .48879 m
.00375 .48879 L
s
P
p
.001 w
0 .52677 m
.00375 .52677 L
s
P
p
.001 w
0 .54606 m
.00375 .54606 L
s
P
p
.001 w
0 .55974 m
.00375 .55974 L
s
P
p
.001 w
0 .57035 m
.00375 .57035 L
s
P
p
.001 w
0 .57902 m
.00375 .57902 L
s
P
p
.001 w
0 .58635 m
.00375 .58635 L
s
P
p
.001 w
0 .59271 m
.00375 .59271 L
s
P
p
.001 w
0 .59831 m
.00375 .59831 L
s
P
p
.002 w
0 0 m
0 .61803 L
s
P
P
p
p
.002 w
.02381 .61178 m
.02381 .61803 L
s
P
p
.002 w
.22058 .61178 m
.22058 .61803 L
s
P
p
.002 w
.41736 .61178 m
.41736 .61803 L
s
P
p
.002 w
.61413 .61178 m
.61413 .61803 L
s
P
p
.002 w
.8109 .61178 m
.8109 .61803 L
s
P
p
.001 w
.06316 .61428 m
.06316 .61803 L
s
P
p
.001 w
.10252 .61428 m
.10252 .61803 L
s
P
p
.001 w
.14187 .61428 m
.14187 .61803 L
s
P
p
.001 w
.18123 .61428 m
.18123 .61803 L
s
P
p
.001 w
.25994 .61428 m
.25994 .61803 L
s
P
p
.001 w
.29929 .61428 m
.29929 .61803 L
s
P
p
.001 w
.33865 .61428 m
.33865 .61803 L
s
P
p
.001 w
.378 .61428 m
.378 .61803 L
s
P
p
.001 w
.45671 .61428 m
.45671 .61803 L
s
P
p
.001 w
.49606 .61428 m
.49606 .61803 L
s
P
p
.001 w
.53542 .61428 m
.53542 .61803 L
s
P
p
.001 w
.57477 .61428 m
.57477 .61803 L
s
P
p
.001 w
.65348 .61428 m
.65348 .61803 L
s
P
p
.001 w
.69284 .61428 m
.69284 .61803 L
s
P
p
.001 w
.73219 .61428 m
.73219 .61803 L
s
P
p
.001 w
.77155 .61428 m
.77155 .61803 L
s
P
p
.001 w
.85026 .61428 m
.85026 .61803 L
s
P
p
.001 w
.88961 .61428 m
.88961 .61803 L
s
P
p
.001 w
.92896 .61428 m
.92896 .61803 L
s
P
p
.001 w
.96832 .61428 m
.96832 .61803 L
s
P
p
.002 w
0 .61803 m
1 .61803 L
s
P
p
.002 w
.99375 .05575 m
1 .05575 L
s
P
p
.002 w
.99375 .16526 m
1 .16526 L
s
P
p
.002 w
.99375 .27478 m
1 .27478 L
s
P
p
.002 w
.99375 .38429 m
1 .38429 L
s
P
p
.002 w
.99375 .4938 m
1 .4938 L
s
P
p
.002 w
.99375 .60332 m
1 .60332 L
s
P
p
.001 w
.99625 .01217 m
1 .01217 L
s
P
p
.001 w
.99625 .02278 m
1 .02278 L
s
P
p
.001 w
.99625 .03145 m
1 .03145 L
s
P
p
.001 w
.99625 .03879 m
1 .03879 L
s
P
p
.001 w
.99625 .04514 m
1 .04514 L
s
P
p
.001 w
.99625 .05074 m
1 .05074 L
s
P
p
.001 w
.99625 .08872 m
1 .08872 L
s
P
p
.001 w
.99625 .108 m
1 .108 L
s
P
p
.001 w
.99625 .12168 m
1 .12168 L
s
P
p
.001 w
.99625 .1323 m
1 .1323 L
s
P
p
.001 w
.99625 .14097 m
1 .14097 L
s
P
p
.001 w
.99625 .1483 m
1 .1483 L
s
P
p
.001 w
.99625 .15465 m
1 .15465 L
s
P
p
.001 w
.99625 .16025 m
1 .16025 L
s
P
p
.001 w
.99625 .19823 m
1 .19823 L
s
P
p
.001 w
.99625 .21751 m
1 .21751 L
s
P
p
.001 w
.99625 .2312 m
1 .2312 L
s
P
p
.001 w
.99625 .24181 m
1 .24181 L
s
P
p
.001 w
.99625 .25048 m
1 .25048 L
s
P
p
.001 w
.99625 .25781 m
1 .25781 L
s
P
p
.001 w
.99625 .26416 m
1 .26416 L
s
P
p
.001 w
.99625 .26977 m
1 .26977 L
s
P
p
.001 w
.99625 .30774 m
1 .30774 L
s
P
p
.001 w
.99625 .32703 m
1 .32703 L
s
P
p
.001 w
.99625 .34071 m
1 .34071 L
s
P
p
.001 w
.99625 .35132 m
1 .35132 L
s
P
p
.001 w
.99625 .36 m
1 .36 L
s
P
p
.001 w
.99625 .36733 m
1 .36733 L
s
P
p
.001 w
.99625 .37368 m
1 .37368 L
s
P
p
.001 w
.99625 .37928 m
1 .37928 L
s
P
p
.001 w
.99625 .41726 m
1 .41726 L
s
P
p
.001 w
.99625 .43654 m
1 .43654 L
s
P
p
.001 w
.99625 .45022 m
1 .45022 L
s
P
p
.001 w
.99625 .46084 m
1 .46084 L
s
P
p
.001 w
.99625 .46951 m
1 .46951 L
s
P
p
.001 w
.99625 .47684 m
1 .47684 L
s
P
p
.001 w
.99625 .48319 m
1 .48319 L
s
P
p
.001 w
.99625 .48879 m
1 .48879 L
s
P
p
.001 w
.99625 .52677 m
1 .52677 L
s
P
p
.001 w
.99625 .54606 m
1 .54606 L
s
P
p
.001 w
.99625 .55974 m
1 .55974 L
s
P
p
.001 w
.99625 .57035 m
1 .57035 L
s
P
p
.001 w
.99625 .57902 m
1 .57902 L
s
P
p
.001 w
.99625 .58635 m
1 .58635 L
s
P
p
.001 w
.99625 .59271 m
1 .59271 L
s
P
p
.001 w
.99625 .59831 m
1 .59831 L
s
P
p
.002 w
1 0 m
1 .61803 L
s
P
P
p
P
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
p
p
.6 g
p
.008 w
.02381 .53758 Mdot
.02774 .01472 Mdot
.03168 .01483 Mdot
.03562 .01503 Mdot
.03955 .01531 Mdot
.04349 .01567 Mdot
.04742 .01611 Mdot
.05136 .01663 Mdot
.05529 .01723 Mdot
.05923 .01792 Mdot
.06316 .01869 Mdot
.0671 .01954 Mdot
.07104 .02048 Mdot
.07497 .0215 Mdot
.07891 .02262 Mdot
.08284 .02382 Mdot
.08678 .02511 Mdot
.09071 .02649 Mdot
.09465 .02797 Mdot
.09858 .02955 Mdot
.10252 .03122 Mdot
.10645 .033 Mdot
.11039 .03488 Mdot
.11433 .03686 Mdot
.11826 .03896 Mdot
.1222 .04117 Mdot
.12613 .04349 Mdot
.13007 .04594 Mdot
.134 .04852 Mdot
.13794 .05123 Mdot
.14187 .05407 Mdot
.14581 .05706 Mdot
.14974 .0602 Mdot
.15368 .06349 Mdot
.15762 .06695 Mdot
.16155 .07059 Mdot
.16549 .07442 Mdot
.16942 .07844 Mdot
.17336 .08267 Mdot
.17729 .08713 Mdot
.18123 .09184 Mdot
.18516 .09681 Mdot
.1891 .10207 Mdot
.19303 .10764 Mdot
.19697 .11356 Mdot
.20091 .11987 Mdot
.20484 .1266 Mdot
.20878 .13382 Mdot
.21271 .14159 Mdot
.21665 .14998 Mdot
.22058 .15912 Mdot
.22452 .16913 Mdot
.22845 .18019 Mdot
.23239 .19255 Mdot
.23632 .20656 Mdot
.24026 .22273 Mdot
.2442 .24186 Mdot
.24813 .26536 Mdot
.25207 .29592 Mdot
.256 .34003 Mdot
.25994 .42179 Mdot
.26387 .52751 Mdot
.26781 .37569 Mdot
.27174 .3211 Mdot
.27568 .2875 Mdot
.27961 .26341 Mdot
.28355 .24481 Mdot
.28749 .22977 Mdot
.29142 .21726 Mdot
.29536 .20664 Mdot
.29929 .19749 Mdot
.30323 .18952 Mdot
.30716 .18252 Mdot
.3111 .17635 Mdot
.31503 .17088 Mdot
.31897 .16602 Mdot
.3229 .1617 Mdot
.32684 .15787 Mdot
.33078 .15447 Mdot
.33471 .15147 Mdot
.33865 .14884 Mdot
.34258 .14654 Mdot
.34652 .14457 Mdot
.35045 .14289 Mdot
.35439 .14151 Mdot
.35832 .14039 Mdot
.36226 .13953 Mdot
.36619 .13893 Mdot
.37013 .13858 Mdot
.37407 .13846 Mdot
.378 .13859 Mdot
.38194 .13895 Mdot
.38587 .13955 Mdot
.38981 .14038 Mdot
.39374 .14146 Mdot
.39768 .14277 Mdot
.40161 .14433 Mdot
.40555 .14615 Mdot
.40948 .14823 Mdot
.41342 .15058 Mdot
.41736 .15321 Mdot
.42129 .15615 Mdot
.42523 .1594 Mdot
.42916 .16299 Mdot
.4331 .16694 Mdot
.43703 .17129 Mdot
.44097 .17607 Mdot
.4449 .18133 Mdot
.44884 .18713 Mdot
.45277 .19352 Mdot
.45671 .2006 Mdot
.46065 .20847 Mdot
.46458 .21729 Mdot
.46852 .22724 Mdot
.47245 .23859 Mdot
.47639 .25171 Mdot
.48032 .26719 Mdot
.48426 .28593 Mdot
.48819 .30956 Mdot
.49213 .34136 Mdot
.49606 .38981 Mdot
.5 .49424 Mdot
.50394 .49424 Mdot
.50787 .38981 Mdot
.51181 .34136 Mdot
.51574 .30956 Mdot
.51968 .28593 Mdot
.52361 .26719 Mdot
.52755 .25171 Mdot
.53148 .23859 Mdot
.53542 .22724 Mdot
.53935 .21729 Mdot
.54329 .20847 Mdot
.54723 .2006 Mdot
.55116 .19352 Mdot
.5551 .18713 Mdot
.55903 .18133 Mdot
.56297 .17607 Mdot
.5669 .17129 Mdot
.57084 .16694 Mdot
.57477 .16299 Mdot
.57871 .1594 Mdot
.58264 .15615 Mdot
.58658 .15321 Mdot
.59052 .15058 Mdot
.59445 .14823 Mdot
.59839 .14615 Mdot
.60232 .14433 Mdot
.60626 .14277 Mdot
.61019 .14146 Mdot
.61413 .14038 Mdot
.61806 .13955 Mdot
.622 .13895 Mdot
.62593 .13859 Mdot
.62987 .13846 Mdot
.63381 .13858 Mdot
.63774 .13893 Mdot
.64168 .13953 Mdot
.64561 .14039 Mdot
.64955 .14151 Mdot
.65348 .14289 Mdot
.65742 .14457 Mdot
.66135 .14654 Mdot
.66529 .14884 Mdot
.66922 .15147 Mdot
.67316 .15447 Mdot
.6771 .15787 Mdot
.68103 .1617 Mdot
.68497 .16602 Mdot
.6889 .17088 Mdot
.69284 .17635 Mdot
.69677 .18252 Mdot
.70071 .18952 Mdot
.70464 .19749 Mdot
.70858 .20664 Mdot
.71251 .21726 Mdot
.71645 .22977 Mdot
.72039 .24481 Mdot
.72432 .26341 Mdot
.72826 .2875 Mdot
.73219 .3211 Mdot
.73613 .37569 Mdot
.74006 .52751 Mdot
.744 .42179 Mdot
.74793 .34003 Mdot
.75187 .29592 Mdot
.7558 .26536 Mdot
.75974 .24186 Mdot
.76368 .22273 Mdot
.76761 .20656 Mdot
.77155 .19255 Mdot
.77548 .18019 Mdot
.77942 .16913 Mdot
.78335 .15912 Mdot
.78729 .14998 Mdot
.79122 .14159 Mdot
.79516 .13382 Mdot
.79909 .1266 Mdot
.80303 .11987 Mdot
.80697 .11356 Mdot
.8109 .10764 Mdot
.81484 .10207 Mdot
.81877 .09681 Mdot
.82271 .09184 Mdot
.82664 .08713 Mdot
.83058 .08267 Mdot
.83451 .07844 Mdot
.83845 .07442 Mdot
.84238 .07059 Mdot
.84632 .06695 Mdot
.85026 .06349 Mdot
.85419 .0602 Mdot
.85813 .05706 Mdot
.86206 .05407 Mdot
.866 .05123 Mdot
.86993 .04852 Mdot
.87387 .04594 Mdot
.8778 .04349 Mdot
.88174 .04117 Mdot
.88567 .03896 Mdot
.88961 .03686 Mdot
.89355 .03488 Mdot
.89748 .033 Mdot
.90142 .03122 Mdot
.90535 .02955 Mdot
.90929 .02797 Mdot
.91322 .02649 Mdot
.91716 .02511 Mdot
.92109 .02382 Mdot
.92503 .02262 Mdot
.92896 .0215 Mdot
.9329 .02048 Mdot
.93684 .01954 Mdot
.94077 .01869 Mdot
.94471 .01792 Mdot
.94864 .01723 Mdot
.95258 .01663 Mdot
.95651 .01611 Mdot
.96045 .01567 Mdot
.96438 .01531 Mdot
.96832 .01503 Mdot
.97226 .01483 Mdot
.97619 .01472 Mdot
P
P
p
1 0 0 r
p
.035 w
.256 .01472 Mdot
P
P
P
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.522676 0.323031 0.97619 0.603319 MathSubStart
%% Graphics
/Courier findfont 8  scalefont  setfont
% Scaling calculations
0.0238095 0.00393546 0.603319 0.109514 [
[(0)] .02381 0 0 2 Msboxa
[(50)] .22058 0 0 2 Msboxa
[(100)] .41736 0 0 2 Msboxa
[(150)] .61413 0 0 2 Msboxa
[(200)] .8109 0 0 2 Msboxa
[(0.00001)] -0.0125 .05575 1 0 Msboxa
[(0.0001)] -0.0125 .16526 1 0 Msboxa
[(0.001)] -0.0125 .27478 1 0 Msboxa
[(0.01)] -0.0125 .38429 1 0 Msboxa
[(0.1)] -0.0125 .4938 1 0 Msboxa
[(1)] -0.0125 .60332 1 0 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 .61903 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
p
p
.002 w
.02381 0 m
.02381 .00625 L
s
P
[(0)] .02381 0 0 2 Mshowa
p
.002 w
.22058 0 m
.22058 .00625 L
s
P
[(50)] .22058 0 0 2 Mshowa
p
.002 w
.41736 0 m
.41736 .00625 L
s
P
[(100)] .41736 0 0 2 Mshowa
p
.002 w
.61413 0 m
.61413 .00625 L
s
P
[(150)] .61413 0 0 2 Mshowa
p
.002 w
.8109 0 m
.8109 .00625 L
s
P
[(200)] .8109 0 0 2 Mshowa
p
.001 w
.06316 0 m
.06316 .00375 L
s
P
p
.001 w
.10252 0 m
.10252 .00375 L
s
P
p
.001 w
.14187 0 m
.14187 .00375 L
s
P
p
.001 w
.18123 0 m
.18123 .00375 L
s
P
p
.001 w
.25994 0 m
.25994 .00375 L
s
P
p
.001 w
.29929 0 m
.29929 .00375 L
s
P
p
.001 w
.33865 0 m
.33865 .00375 L
s
P
p
.001 w
.378 0 m
.378 .00375 L
s
P
p
.001 w
.45671 0 m
.45671 .00375 L
s
P
p
.001 w
.49606 0 m
.49606 .00375 L
s
P
p
.001 w
.53542 0 m
.53542 .00375 L
s
P
p
.001 w
.57477 0 m
.57477 .00375 L
s
P
p
.001 w
.65348 0 m
.65348 .00375 L
s
P
p
.001 w
.69284 0 m
.69284 .00375 L
s
P
p
.001 w
.73219 0 m
.73219 .00375 L
s
P
p
.001 w
.77155 0 m
.77155 .00375 L
s
P
p
.001 w
.85026 0 m
.85026 .00375 L
s
P
p
.001 w
.88961 0 m
.88961 .00375 L
s
P
p
.001 w
.92896 0 m
.92896 .00375 L
s
P
p
.001 w
.96832 0 m
.96832 .00375 L
s
P
p
.002 w
0 0 m
1 0 L
s
P
p
.002 w
0 .05575 m
.00625 .05575 L
s
P
[(0.00001)] -0.0125 .05575 1 0 Mshowa
p
.002 w
0 .16526 m
.00625 .16526 L
s
P
[(0.0001)] -0.0125 .16526 1 0 Mshowa
p
.002 w
0 .27478 m
.00625 .27478 L
s
P
[(0.001)] -0.0125 .27478 1 0 Mshowa
p
.002 w
0 .38429 m
.00625 .38429 L
s
P
[(0.01)] -0.0125 .38429 1 0 Mshowa
p
.002 w
0 .4938 m
.00625 .4938 L
s
P
[(0.1)] -0.0125 .4938 1 0 Mshowa
p
.002 w
0 .60332 m
.00625 .60332 L
s
P
[(1)] -0.0125 .60332 1 0 Mshowa
p
.001 w
0 .01217 m
.00375 .01217 L
s
P
p
.001 w
0 .02278 m
.00375 .02278 L
s
P
p
.001 w
0 .03145 m
.00375 .03145 L
s
P
p
.001 w
0 .03879 m
.00375 .03879 L
s
P
p
.001 w
0 .04514 m
.00375 .04514 L
s
P
p
.001 w
0 .05074 m
.00375 .05074 L
s
P
p
.001 w
0 .08872 m
.00375 .08872 L
s
P
p
.001 w
0 .108 m
.00375 .108 L
s
P
p
.001 w
0 .12168 m
.00375 .12168 L
s
P
p
.001 w
0 .1323 m
.00375 .1323 L
s
P
p
.001 w
0 .14097 m
.00375 .14097 L
s
P
p
.001 w
0 .1483 m
.00375 .1483 L
s
P
p
.001 w
0 .15465 m
.00375 .15465 L
s
P
p
.001 w
0 .16025 m
.00375 .16025 L
s
P
p
.001 w
0 .19823 m
.00375 .19823 L
s
P
p
.001 w
0 .21751 m
.00375 .21751 L
s
P
p
.001 w
0 .2312 m
.00375 .2312 L
s
P
p
.001 w
0 .24181 m
.00375 .24181 L
s
P
p
.001 w
0 .25048 m
.00375 .25048 L
s
P
p
.001 w
0 .25781 m
.00375 .25781 L
s
P
p
.001 w
0 .26416 m
.00375 .26416 L
s
P
p
.001 w
0 .26977 m
.00375 .26977 L
s
P
p
.001 w
0 .30774 m
.00375 .30774 L
s
P
p
.001 w
0 .32703 m
.00375 .32703 L
s
P
p
.001 w
0 .34071 m
.00375 .34071 L
s
P
p
.001 w
0 .35132 m
.00375 .35132 L
s
P
p
.001 w
0 .36 m
.00375 .36 L
s
P
p
.001 w
0 .36733 m
.00375 .36733 L
s
P
p
.001 w
0 .37368 m
.00375 .37368 L
s
P
p
.001 w
0 .37928 m
.00375 .37928 L
s
P
p
.001 w
0 .41726 m
.00375 .41726 L
s
P
p
.001 w
0 .43654 m
.00375 .43654 L
s
P
p
.001 w
0 .45022 m
.00375 .45022 L
s
P
p
.001 w
0 .46084 m
.00375 .46084 L
s
P
p
.001 w
0 .46951 m
.00375 .46951 L
s
P
p
.001 w
0 .47684 m
.00375 .47684 L
s
P
p
.001 w
0 .48319 m
.00375 .48319 L
s
P
p
.001 w
0 .48879 m
.00375 .48879 L
s
P
p
.001 w
0 .52677 m
.00375 .52677 L
s
P
p
.001 w
0 .54606 m
.00375 .54606 L
s
P
p
.001 w
0 .55974 m
.00375 .55974 L
s
P
p
.001 w
0 .57035 m
.00375 .57035 L
s
P
p
.001 w
0 .57902 m
.00375 .57902 L
s
P
p
.001 w
0 .58635 m
.00375 .58635 L
s
P
p
.001 w
0 .59271 m
.00375 .59271 L
s
P
p
.001 w
0 .59831 m
.00375 .59831 L
s
P
p
.002 w
0 0 m
0 .61803 L
s
P
P
p
p
.002 w
.02381 .61178 m
.02381 .61803 L
s
P
p
.002 w
.22058 .61178 m
.22058 .61803 L
s
P
p
.002 w
.41736 .61178 m
.41736 .61803 L
s
P
p
.002 w
.61413 .61178 m
.61413 .61803 L
s
P
p
.002 w
.8109 .61178 m
.8109 .61803 L
s
P
p
.001 w
.06316 .61428 m
.06316 .61803 L
s
P
p
.001 w
.10252 .61428 m
.10252 .61803 L
s
P
p
.001 w
.14187 .61428 m
.14187 .61803 L
s
P
p
.001 w
.18123 .61428 m
.18123 .61803 L
s
P
p
.001 w
.25994 .61428 m
.25994 .61803 L
s
P
p
.001 w
.29929 .61428 m
.29929 .61803 L
s
P
p
.001 w
.33865 .61428 m
.33865 .61803 L
s
P
p
.001 w
.378 .61428 m
.378 .61803 L
s
P
p
.001 w
.45671 .61428 m
.45671 .61803 L
s
P
p
.001 w
.49606 .61428 m
.49606 .61803 L
s
P
p
.001 w
.53542 .61428 m
.53542 .61803 L
s
P
p
.001 w
.57477 .61428 m
.57477 .61803 L
s
P
p
.001 w
.65348 .61428 m
.65348 .61803 L
s
P
p
.001 w
.69284 .61428 m
.69284 .61803 L
s
P
p
.001 w
.73219 .61428 m
.73219 .61803 L
s
P
p
.001 w
.77155 .61428 m
.77155 .61803 L
s
P
p
.001 w
.85026 .61428 m
.85026 .61803 L
s
P
p
.001 w
.88961 .61428 m
.88961 .61803 L
s
P
p
.001 w
.92896 .61428 m
.92896 .61803 L
s
P
p
.001 w
.96832 .61428 m
.96832 .61803 L
s
P
p
.002 w
0 .61803 m
1 .61803 L
s
P
p
.002 w
.99375 .05575 m
1 .05575 L
s
P
p
.002 w
.99375 .16526 m
1 .16526 L
s
P
p
.002 w
.99375 .27478 m
1 .27478 L
s
P
p
.002 w
.99375 .38429 m
1 .38429 L
s
P
p
.002 w
.99375 .4938 m
1 .4938 L
s
P
p
.002 w
.99375 .60332 m
1 .60332 L
s
P
p
.001 w
.99625 .01217 m
1 .01217 L
s
P
p
.001 w
.99625 .02278 m
1 .02278 L
s
P
p
.001 w
.99625 .03145 m
1 .03145 L
s
P
p
.001 w
.99625 .03879 m
1 .03879 L
s
P
p
.001 w
.99625 .04514 m
1 .04514 L
s
P
p
.001 w
.99625 .05074 m
1 .05074 L
s
P
p
.001 w
.99625 .08872 m
1 .08872 L
s
P
p
.001 w
.99625 .108 m
1 .108 L
s
P
p
.001 w
.99625 .12168 m
1 .12168 L
s
P
p
.001 w
.99625 .1323 m
1 .1323 L
s
P
p
.001 w
.99625 .14097 m
1 .14097 L
s
P
p
.001 w
.99625 .1483 m
1 .1483 L
s
P
p
.001 w
.99625 .15465 m
1 .15465 L
s
P
p
.001 w
.99625 .16025 m
1 .16025 L
s
P
p
.001 w
.99625 .19823 m
1 .19823 L
s
P
p
.001 w
.99625 .21751 m
1 .21751 L
s
P
p
.001 w
.99625 .2312 m
1 .2312 L
s
P
p
.001 w
.99625 .24181 m
1 .24181 L
s
P
p
.001 w
.99625 .25048 m
1 .25048 L
s
P
p
.001 w
.99625 .25781 m
1 .25781 L
s
P
p
.001 w
.99625 .26416 m
1 .26416 L
s
P
p
.001 w
.99625 .26977 m
1 .26977 L
s
P
p
.001 w
.99625 .30774 m
1 .30774 L
s
P
p
.001 w
.99625 .32703 m
1 .32703 L
s
P
p
.001 w
.99625 .34071 m
1 .34071 L
s
P
p
.001 w
.99625 .35132 m
1 .35132 L
s
P
p
.001 w
.99625 .36 m
1 .36 L
s
P
p
.001 w
.99625 .36733 m
1 .36733 L
s
P
p
.001 w
.99625 .37368 m
1 .37368 L
s
P
p
.001 w
.99625 .37928 m
1 .37928 L
s
P
p
.001 w
.99625 .41726 m
1 .41726 L
s
P
p
.001 w
.99625 .43654 m
1 .43654 L
s
P
p
.001 w
.99625 .45022 m
1 .45022 L
s
P
p
.001 w
.99625 .46084 m
1 .46084 L
s
P
p
.001 w
.99625 .46951 m
1 .46951 L
s
P
p
.001 w
.99625 .47684 m
1 .47684 L
s
P
p
.001 w
.99625 .48319 m
1 .48319 L
s
P
p
.001 w
.99625 .48879 m
1 .48879 L
s
P
p
.001 w
.99625 .52677 m
1 .52677 L
s
P
p
.001 w
.99625 .54606 m
1 .54606 L
s
P
p
.001 w
.99625 .55974 m
1 .55974 L
s
P
p
.001 w
.99625 .57035 m
1 .57035 L
s
P
p
.001 w
.99625 .57902 m
1 .57902 L
s
P
p
.001 w
.99625 .58635 m
1 .58635 L
s
P
p
.001 w
.99625 .59271 m
1 .59271 L
s
P
p
.001 w
.99625 .59831 m
1 .59831 L
s
P
p
.002 w
1 0 m
1 .61803 L
s
P
P
p
P
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
p
p
.6 g
p
.008 w
.02381 .53758 Mdot
.02774 .01472 Mdot
.03168 .01483 Mdot
.03562 .01503 Mdot
.03955 .01531 Mdot
.04349 .01567 Mdot
.04742 .01611 Mdot
.05136 .01663 Mdot
.05529 .01723 Mdot
.05923 .01792 Mdot
.06316 .01869 Mdot
.0671 .01954 Mdot
.07104 .02048 Mdot
.07497 .0215 Mdot
.07891 .02262 Mdot
.08284 .02382 Mdot
.08678 .02511 Mdot
.09071 .02649 Mdot
.09465 .02797 Mdot
.09858 .02955 Mdot
.10252 .03122 Mdot
.10645 .033 Mdot
.11039 .03488 Mdot
.11433 .03686 Mdot
.11826 .03896 Mdot
.1222 .04117 Mdot
.12613 .04349 Mdot
.13007 .04594 Mdot
.134 .04852 Mdot
.13794 .05123 Mdot
.14187 .05407 Mdot
.14581 .05706 Mdot
.14974 .0602 Mdot
.15368 .06349 Mdot
.15762 .06695 Mdot
.16155 .07059 Mdot
.16549 .07442 Mdot
.16942 .07844 Mdot
.17336 .08267 Mdot
.17729 .08713 Mdot
.18123 .09184 Mdot
.18516 .09681 Mdot
.1891 .10207 Mdot
.19303 .10764 Mdot
.19697 .11356 Mdot
.20091 .11987 Mdot
.20484 .1266 Mdot
.20878 .13382 Mdot
.21271 .14159 Mdot
.21665 .14998 Mdot
.22058 .15912 Mdot
.22452 .16913 Mdot
.22845 .18019 Mdot
.23239 .19255 Mdot
.23632 .20656 Mdot
.24026 .22273 Mdot
.2442 .24186 Mdot
.24813 .26536 Mdot
.25207 .29592 Mdot
.256 .34003 Mdot
.25994 .42179 Mdot
.26387 .52751 Mdot
.26781 .37569 Mdot
.27174 .3211 Mdot
.27568 .2875 Mdot
.27961 .26341 Mdot
.28355 .24481 Mdot
.28749 .22977 Mdot
.29142 .21726 Mdot
.29536 .20664 Mdot
.29929 .19749 Mdot
.30323 .18952 Mdot
.30716 .18252 Mdot
.3111 .17635 Mdot
.31503 .17088 Mdot
.31897 .16602 Mdot
.3229 .1617 Mdot
.32684 .15787 Mdot
.33078 .15447 Mdot
.33471 .15147 Mdot
.33865 .14884 Mdot
.34258 .14654 Mdot
.34652 .14457 Mdot
.35045 .14289 Mdot
.35439 .14151 Mdot
.35832 .14039 Mdot
.36226 .13953 Mdot
.36619 .13893 Mdot
.37013 .13858 Mdot
.37407 .13846 Mdot
.378 .13859 Mdot
.38194 .13895 Mdot
.38587 .13955 Mdot
.38981 .14038 Mdot
.39374 .14146 Mdot
.39768 .14277 Mdot
.40161 .14433 Mdot
.40555 .14615 Mdot
.40948 .14823 Mdot
.41342 .15058 Mdot
.41736 .15321 Mdot
.42129 .15615 Mdot
.42523 .1594 Mdot
.42916 .16299 Mdot
.4331 .16694 Mdot
.43703 .17129 Mdot
.44097 .17607 Mdot
.4449 .18133 Mdot
.44884 .18713 Mdot
.45277 .19352 Mdot
.45671 .2006 Mdot
.46065 .20847 Mdot
.46458 .21729 Mdot
.46852 .22724 Mdot
.47245 .23859 Mdot
.47639 .25171 Mdot
.48032 .26719 Mdot
.48426 .28593 Mdot
.48819 .30956 Mdot
.49213 .34136 Mdot
.49606 .38981 Mdot
.5 .49424 Mdot
.50394 .49424 Mdot
.50787 .38981 Mdot
.51181 .34136 Mdot
.51574 .30956 Mdot
.51968 .28593 Mdot
.52361 .26719 Mdot
.52755 .25171 Mdot
.53148 .23859 Mdot
.53542 .22724 Mdot
.53935 .21729 Mdot
.54329 .20847 Mdot
.54723 .2006 Mdot
.55116 .19352 Mdot
.5551 .18713 Mdot
.55903 .18133 Mdot
.56297 .17607 Mdot
.5669 .17129 Mdot
.57084 .16694 Mdot
.57477 .16299 Mdot
.57871 .1594 Mdot
.58264 .15615 Mdot
.58658 .15321 Mdot
.59052 .15058 Mdot
.59445 .14823 Mdot
.59839 .14615 Mdot
.60232 .14433 Mdot
.60626 .14277 Mdot
.61019 .14146 Mdot
.61413 .14038 Mdot
.61806 .13955 Mdot
.622 .13895 Mdot
.62593 .13859 Mdot
.62987 .13846 Mdot
.63381 .13858 Mdot
.63774 .13893 Mdot
.64168 .13953 Mdot
.64561 .14039 Mdot
.64955 .14151 Mdot
.65348 .14289 Mdot
.65742 .14457 Mdot
.66135 .14654 Mdot
.66529 .14884 Mdot
.66922 .15147 Mdot
.67316 .15447 Mdot
.6771 .15787 Mdot
.68103 .1617 Mdot
.68497 .16602 Mdot
.6889 .17088 Mdot
.69284 .17635 Mdot
.69677 .18252 Mdot
.70071 .18952 Mdot
.70464 .19749 Mdot
.70858 .20664 Mdot
.71251 .21726 Mdot
.71645 .22977 Mdot
.72039 .24481 Mdot
.72432 .26341 Mdot
.72826 .2875 Mdot
.73219 .3211 Mdot
.73613 .37569 Mdot
.74006 .52751 Mdot
.744 .42179 Mdot
.74793 .34003 Mdot
.75187 .29592 Mdot
.7558 .26536 Mdot
.75974 .24186 Mdot
.76368 .22273 Mdot
.76761 .20656 Mdot
.77155 .19255 Mdot
.77548 .18019 Mdot
.77942 .16913 Mdot
.78335 .15912 Mdot
.78729 .14998 Mdot
.79122 .14159 Mdot
.79516 .13382 Mdot
.79909 .1266 Mdot
.80303 .11987 Mdot
.80697 .11356 Mdot
.8109 .10764 Mdot
.81484 .10207 Mdot
.81877 .09681 Mdot
.82271 .09184 Mdot
.82664 .08713 Mdot
.83058 .08267 Mdot
.83451 .07844 Mdot
.83845 .07442 Mdot
.84238 .07059 Mdot
.84632 .06695 Mdot
.85026 .06349 Mdot
.85419 .0602 Mdot
.85813 .05706 Mdot
.86206 .05407 Mdot
.866 .05123 Mdot
.86993 .04852 Mdot
.87387 .04594 Mdot
.8778 .04349 Mdot
.88174 .04117 Mdot
.88567 .03896 Mdot
.88961 .03686 Mdot
.89355 .03488 Mdot
.89748 .033 Mdot
.90142 .03122 Mdot
.90535 .02955 Mdot
.90929 .02797 Mdot
.91322 .02649 Mdot
.91716 .02511 Mdot
.92109 .02382 Mdot
.92503 .02262 Mdot
.92896 .0215 Mdot
.9329 .02048 Mdot
.93684 .01954 Mdot
.94077 .01869 Mdot
.94471 .01792 Mdot
.94864 .01723 Mdot
.95258 .01663 Mdot
.95651 .01611 Mdot
.96045 .01567 Mdot
.96438 .01531 Mdot
.96832 .01503 Mdot
.97226 .01483 Mdot
.97619 .01472 Mdot
P
P
p
1 0 0 r
p
.035 w
.25994 .01472 Mdot
P
P
P
MathSubEnd
P
% End of sub-graphic
P
P
% End of Graphics
MathPictureEnd

:[font = output; output; inactive; preserveAspect; endGroup; endGroup; endGroup]
{3, 5}
;[o]
{3, 5}
:[font = section; inactive; preserveAspect; startGroup]
Example 2
:[font = subsubsection; inactive; preserveAspect; startGroup]
Try me!
:[font = input; preserveAspect; startGroup]
SeedRandom[1234];
RunShorsAlgorithm[15]
:[font = output; output; inactive; preserveAspect; endGroup; endGroup; endGroup]
{3, 5}
;[o]
{3, 5}
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
Commentary Functions
:[font = input; initialization; preserveAspect; startGroup]
*)
Needs["Graphics`Graphics`"]

DescribeStep1[x_, n_]:=
	(Print[StringForm["Step 1: Picking a random integer x, 1 < x < `1`, that is co-prime to `1`.", n]];
	 Print[StringForm[">> Picked x == `1`.", x]];
	 Print["\n"]
	)
	 
DescribeStep2[q_, n_]:=
	(Print[StringForm["Step 2: Picking a \"smooth\" q, i.e. an integer of order O(n^2) ~ `1`", n^2]];
	 Print["   that has small prime factors."];
	 Print[StringForm[">> Picked q == `1`.", q]]
	)

DescribeStep3[x_, q_, n_]:=
	(Print[StringForm["Step 3: Computing the period of `1` mod `2`.", x^a, n]];
	 Print["Repeat steps 3(a)-3(g) O(log(q)) times."];
	 Print["\nStep 3(a):"];
	 Print["Initially, place Reg1 and Reg2 in the state |0,0>."];
	 ListPlot[{{0,0}}, 
         PlotStyle->PointSize[0.035],
         PlotRange->{{0,q},{0,n}},
         GridLines->Automatic,
         Frame->True,
         FrameLabel->{"Contents Reg1", "Contents Reg2"},
         RotateLabel->True,
         PlotLabel->"Initialize Reg1 & Reg2 as |0,0>"]
   	)
	
DescribeStep4[reg1_]:=
	(Print["\nStep 3(b):"];
	 Print["Loading Reg1 with a superposition of all integers in the range 0 to q-1,"];
	 Print["   i.e. creating the superposition 1/Sqrt[q] Sum[ket[a], {a,0,q-1}"];
	 Print["This puts Reg1 in the state:"];
	 Print["Reg1 = ", Short[reg1,8]]
	)
	

DescribeStep5[reg1_, q_, n_]:=
	Module[{contentsReg1, contentsReg2},
		contentsReg1 = Contents[reg1];
		contentsReg2 = Table[0, {Length[reg1]}];
		ListPlot[MapThread[{#1, #2}&, {contentsReg1, contentsReg2}], 
	             PlotLabel->"Load Reg1 with 1/Sqrt[q] Sum[|a,0>, {a,0,q-1}]",
	             Frame->True,
	             GridLines->Automatic,
	             FrameLabel->{"Contents of Reg1", "Contents of Reg2"},
	             RotateLabel->True,
	             PlotRange->{{0,q},{0,n}},
	             PlotStyle->PointSize[0.02]]
	]

DescribeStep6[reg1_, reg2_, q_, n_]:=
	Module[{contentsReg1, contentsReg2, data},
		Print["\nStep 3(c):"];
		Print[StringForm["Loading Reg2 with `1` mod `2`", x^a, n]];
	 	Print["This puts Reg2 in a state representing a superposition of the integers:"];
		Print[ShortRegister[reg2, n]];
		Print["\n"];
			(* Next, only need to see a subset of the data as
			   the period of x^a mod n is at most n.
			*)
		contentsReg1 = Take[Contents[reg1], {1, Ceiling[1.5 n]}];
		contentsReg2 = Take[reg2, {1, Ceiling[1.5 n]}]; 
		data = Transpose[{contentsReg1, contentsReg2}];
		Show[ListPlot[data, 
	                  Frame->True,
	                  PlotRange->{{0, Ceiling[1.5 n]-1}, {0, Max[contentsReg2]+1}},
	                  PlotLabel->"Put superposition x^a mod n in Reg2 \n 1/Sqrt[q] Sum[|a, x^a mod n>,{a,0,q-1}]",
	                  GridLines->Automatic,
	                  FrameLabel->{"Contents Reg1", "Contents Reg2"},
	                  RotateLabel->True,
	                  PlotJoined->True,
	                  PlotStyle->Dashing[{0.01,0.01}],
	                  DisplayFunction->Identity],
	         ListPlot[data,
	                  PlotJoined->False,
	                  PlotStyle->PointSize[0.02],
	                  DisplayFunction->Identity],
	         DisplayFunction :> $DisplayFunction
	    ]
	]

DescribeStep7[reg1_, reg2_, q_, n_, measurement_]:=
	Module[{contentsReg1, contentsReg2, data},
		PrintPartOfRegister[reg2, n]; 
			(* Next, only need to see a subset of the data as
			   the period of x^a mod n is at most n.
			*)
		contentsReg1 = Take[Contents[reg1], {1, Ceiling[1.5 n]}];
		contentsReg2 = Take[reg2, {1, Ceiling[1.5 n]}]; 
		data = Transpose[{contentsReg1, contentsReg2}];
		Show[ListPlot[data, 
	                  Frame->True,
	                  PlotRange->{{0, Ceiling[1.5 n]-1}, {0, Max[contentsReg2]+1}},
	                  PlotLabel->StringJoin["Measure Reg2 = ",
	                                        ToString[measurement]],
	                  GridLines->Automatic,
	                  FrameLabel->{"Contents Reg1", "Contents Reg2"},
	                  RotateLabel->True,
	                  PlotJoined->True,
	                  PlotStyle->{GrayLevel[0.6], Dashing[{0.01,0.01}]},
	                  DisplayFunction->Identity],
	         ListPlot[data,
	                  PlotJoined->False,
	                  PlotStyle->{GrayLevel[0.6], PointSize[0.02]},
	                  DisplayFunction->Identity],
	         Graphics[{RGBColor[1,0,0],
	                   PointSize[0.05],
	                   Point[{0,measurement}]
	                  }],
	         DisplayFunction :> $DisplayFunction
	    ]
	]
	
	

DescribeStep8[reg1_, reg2_, projectReg1_, measureReg2_, n_]:=
	Module[{maxXValue, maxYValue, contentsProjReg1, contentsReg2, data},
		Print["projectReg1 = ", Short[projectReg1,8]];
		maxXValue = Max[Take[Contents[reg1], {1, Ceiling[1.5 n]}]];
		maxYValue = Max[reg2]+1; (* reg2 is already just a list of x^a mod n *)
		contentsProjReg1 = Contents[projectReg1];
		contentsReg2 = Table[measureReg2, {Length[contentsProjReg1]}];
		data = Select[Transpose[{contentsProjReg1, contentsReg2}], 
		              (#[[2]]==measureReg2 && 
		               #[[1]]<=maxXValue)&];  (*just plot subset*)
		ListPlot[data,
		         Frame->True,
	             PlotLabel->StringForm["Project Reg1: {a:x^a mod n = `1`}", measureReg2],
	             GridLines->Automatic,
	             FrameLabel->{StringForm["Contents Reg1 {a:x^a mod n = `1`}", measureReg2],
	                          "Contents Reg2"},
	             RotateLabel->True,
	             PlotJoined->False,
	             PlotStyle->PointSize[0.02],
	             PlotRange->{0, maxYValue}
	            ]
	 ]
	 
DescribeStep9[fourierReg1_, measureReg2_]:=
	Module[{probs, conts, data},
		Print["The Fourier transform puts Reg1 in the state:\n"];
		Print["Fourier = ", Short[fourierReg1, 8]]; 
		probs = Probabilities[fourierReg1];
		conts = Contents[fourierReg1];
		data  = Transpose[{conts, probs}];
		$dft = data;
		LogListPlot[data,
		            Frame->True,
	                PlotLabel->"Compute Discrete Fourier Transform of Reg1",
	                GridLines->Automatic,
	                FrameLabel->
	                	{StringForm["Contents Reg1 {a:x^a mod n = `1`}", measureReg2],
	                     "ln(Pr(Measure a))"
	                    },
	                RotateLabel->True,
	                PlotJoined->False,
	                PlotStyle->PointSize[0.01]
		           ]
	]
	
DescribeStep10[fourierReg1_, measureReg2_, oneSampleOfDFT_]:=
	Module[{probs, conts, data, dftPlot, samplePlot},
		probs = Probabilities[fourierReg1];
		conts = Contents[fourierReg1];
		data  = Transpose[{conts, probs}];
		dftPlot =
			LogListPlot[data,
		            Frame->True,
	                PlotLabel->"Compute Discrete Fourier Transform of Reg1",
	                GridLines->Automatic,
	                FrameLabel->
	                	{StringForm["Contents Reg1 {a:x^a mod n = `1`}", measureReg2],
	                     "ln(Pr(Measure a))"
	                    },
	                RotateLabel->True,
	                PlotJoined->False,
	                PlotStyle->PointSize[0.01],
	                DisplayFunction->Identity
		   ];
		samplePlot = LogListPlot[{{oneSampleOfDFT, Min[probs]}},
		                         PlotStyle->{RGBColor[1,0,0], 
		                                     PointSize[0.035]},
		                         DisplayFunction->Identity];
		Show[dftPlot, samplePlot, DisplayFunction:>$DisplayFunction]
	]
	
DescribeStep11[fourierReg1_, samples_]:=
	Module[{probs, conts, data, dftPlot, plots},
		probs = Probabilities[fourierReg1];
		conts = Contents[fourierReg1];
		data  = Transpose[{conts, probs}];
		$dft = data;
		multiplesOfPeriod = Map[{#, Min[probs]}&, samples];
		dftPlot =
			LogListPlot[data,
		                Frame->True,
		                PlotStyle->{GrayLevel[0.6]},
	                    PlotJoined->False,
	                    DisplayFunction->Identity
		               ];
		plots = Map[Show[dftPlot, 
		                 LogListPlot[{#},
		                             PlotStyle->{RGBColor[1,0,0], 
		                                         PointSize[0.035]},
		                             DisplayFunction->Identity
		                            ], 
		                 DisplayFunction->Identity
		           ]&, multiplesOfPeriod];
		$DefaultFont = {"Courier", 8};
		Show[GraphicsArray[Partition[plots,2]],
		     PlotLabel->"Repeat Shors Algm O(ln(q)) times. \n Obtain samples from DFT in Reg1",
		     DisplayFunction:>$DisplayFunction]
	]
	
DescribeStep12[]:=
	(Print["Each sample provides a value k"];
	 Print["Finding the closest rational to k/q, whose denominator is less than n."];
	 Print["Each such rational has the form lambda/r, where r is the period."]
	)
	
DescribeStep13[x_,r_,n_]:=
	Module[{fac1, fac2},
	 Print["\nStep 5: Obtain the factors of n from the period, r."];
	 Print["Computing the factors of n from"];
	 Print["GCD[x^(r/2) - 1, n] and"];
	 Print["GCD[x^(r/2) + 1, n]"];
	 Print["In this case, x=", x, ", r=",r,", n=",n];
	 fac1 = GCD[x^(r/2) - 1, n];
	 fac2 = GCD[x^(r/2) + 1, n];
	 Print["GCD[",x^(r/2)," - 1", ", ", n,"] = ", fac1];
	 Print["GCD[",x^(r/2)," + 1", ", ", n,"] = ", fac2];
	 Print["So the factors of n=",n," are ",fac1," and ",fac2,"."]
	]
	
		
	

(* w_. ket[i_] + kets_. is a superposition of states of a quantum
   memory register. Probabilities[...] gives the probability with
   which each result would be obtained upon measuring the state of
   the register. Contents[...] gives the actual values that are
   stored in superposition in the register.
*)
Probabilities[w_. ket[i_] + kets_.]:=
	Module[{amplitudes},
		amplitudes = Map[#[[1]]&, Apply[List, w ket[i] + kets]];
		Abs[amplitudes/Sqrt[Apply[Plus, Abs[amplitudes]^2]]]^2
	]

Probabilities[superposition_List]:=
	Probabilities[Apply[Plus, superposition]]

Contents[w_. ket[i_] + kets_.]:=
	Map[#[[2,1]]&, Apply[List, w ket[i] + kets]]

Contents[superposition_List]:=
	Contents[Apply[Plus, superposition]]

(*
:[font = message; inactive; preserveAspect]
General::spell1: Possible spelling error: new symbol name "Contents"
     is similar to existing symbol "Contexts".
:[font = message; inactive; preserveAspect]
General::spell1: Possible spelling error: new symbol name "maxYValue"
     is similar to existing symbol "maxXValue".
:[font = message; inactive; preserveAspect]
General::spell1: Possible spelling error: new symbol name "DescribeStep12"
     is similar to existing symbol "DescribeStep2".
:[font = message; inactive; preserveAspect; endGroup]
General::spell1: Possible spelling error: new symbol name "DescribeStep13"
     is similar to existing symbol "DescribeStep3".
:[font = input; initialization; preserveAspect; endGroup]
*)
ShortRegister[list_, n_]:=
	Print[list] /; Length[list] <= 2n
	
ShortRegister[list_, n_]:=
	Module[{blanks},
		blanks = Table[", ", {Length[list]}];
		elems = Drop[Flatten[MapThread[{ToString[#1], #2}&, 
		                               {list, blanks}]], -1];
		Join[{"{"},
		     Take[elems, n],
		     {"  ...  "},
		     Take[elems, -n],
		     {"}"}
		    ] // StringJoin
	]
(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
Code for simulating Shor's algorithm
:[font = input; initialization; preserveAspect; startGroup]
*)
Needs["Statistics`DataManipulation`"]

Options[RunShorsAlgorithm] = {Period->QuantumMethod};

RunShorsAlgorithm[n_, opts___]:=
	Module[{method,x,q,r},
		$DefaultFont = {"Courier", 10};
		method = Period /. {opts} /. Options[RunShorsAlgorithm];
		x = PickRandomInteger[n];
		DescribeStep1[x, n];
		q = PickGoodSmoothq[n];
		DescribeStep2[q, n];
		DescribeStep3[x, q, n];
		r = Which[method===QuantumMethod, Period[x, n, q],
		          method===ClassicalMethod, PeriodViaClassicalAlgorithm[x, n, q],
		          True, Message[RunShorsAlgorithm::method]; Abort[]
		         ];
		Print["Period was r=",r];
		If[EvenQ[r],
		   (DescribeStep13[x,r,n];
		    {GCD[x^(r/2) - 1, n], GCD[x^(r/2) + 1, n]}
		   ),
		   Message[RunShorsAlgorithm::odd, r]
		  ]
	]

RunShorsAlgorithm::usage =
	"RunShorsAlgorithm[n] creates a simulation of how a \
	quantum computer would find the factors of n using Peter \
	Shor's quantum factoring algorithm. \
	You can give RunShorsAlgorithm various options that control \
	the output from the simulator. The period of x^a mod n can be \
	calculated in one of two \
	ways. If you set Period->QuantumMethod (the default) then \
	RunShorsAlgorithm performs a faithful quantum simulation of \
	the steps a quantum computer would take to compute the period \
	of x^a mod n. This can be slow because of the need to \
	compute a discrete Fourier transform. If you are only \
	interested in seeing what factors a quantum computer would \
	have found (not how it did it) then you can set \
	Period->ClassicalMethod. This returns the same result as the \
	quantum simulation but computes the period in a classical way.";

RunShorsAlgorithm::method =
	"The method for computing the period must be either \
	Period->QuantumMethod or Period->ClassicalMethod.";

RunShorsAlgorithm::odd =
	"The period was an odd number (r=`1`). Shor's quantum \
	factoring algorithm failed. Try again!";


(*
:[font = message; inactive; preserveAspect; endGroup]
General::spell1: Possible spelling error: new symbol name "method"
     is similar to existing symbol "Method".
:[font = subsection; inactive; preserveAspect; startGroup]
Pick a Random Integer Co-prime to n
:[font = input; initialization; preserveAspect; endGroup]
*)
(* Picks a random integer, x, that is co-prime to n.
   Two integers are co-prime if GCD[x,n]==1.
*)
PickRandomInteger[n_]:=
	Module[{x},
		x = n;
		While[GCD[x,n]=!=1,
		      x = Random[Integer, {2,n-1}]; (* choose random integer < n *)
		     ];
		x
	]

(*
:[font = subsection; inactive; preserveAspect; startGroup]
Pick a Smooth q
:[font = input; initialization; preserveAspect; endGroup]
*)
(* Pick a smooth q i.e. an integer in n^2 <= q <= 2 n^2 that
   has small prime factors. Deutsch has shown that if you pick 
   q=2^L for some integer L (still with n^2 <= q=2^L <= 2 n^2), 
   then you can compute the discrete Fourier transform (needed 
   later in the algorithm) very efficiently with a simple quantum 
   circuit. However, q=2^L is not necessarily the SMALLEST q that 
   is usable. In our (classical) simulation the size of q affects 
   the efficiency of the simulator. Hence I opted to go with Peter 
   Shor's original specification of q as being a smooth number of 
   order O(n^2). I actually generate a few such smooth q's and
   pick the smallest provided it is smaller than the least power
   of 2 greater than n^2 (i.e. a q of the form 
   n^2 <= q=2^L << 2 n^2). This was I ensure I am using about as
   small a q as I can (which speeds up the computation of the
   discrete Fourier transform. Computing the DFT is the slowest 
   step which dominates the time to factor
   n in this simulator. I really should speed it up).
   
   The interpretation of a "small" prime being one of order 
   O(Log[n]) is mine. It might be a bit conservative.
*)
PickGoodSmoothq[n_]:=
	Module[{smallPrimes, maxExponents},
		smallPrimes  = Table[Prime[i],{i,1,Log[n]}];
		maxExponents = Map[Floor[Log[#, N[2 n^2]]]&, smallPrimes];
		Min[Join[Table[PickSmoothq[n, smallPrimes, maxExponents], {20}],
		         {2^Ceiling[N[Log[2, n^2]]]}
		        ]  (* i.e. the latter is a q s.t. n^2 <= q=2^L <= 2 n^2 *)
		   ]
	]
	
PickSmoothq[n_, smallPrimes_, maxExponents_]:=
	Module[{q},
		q = 0;
		While[Not[n^2 <= q <= 2 n^2],
			  q = Guessq[smallPrimes, maxExponents]
			 ];
		q
	]

Guessq[primes_, expts_]:=
	Apply[Times, 
	      MapThread[#1^Random[Integer,{0,#2}]&, {primes, expts}]]
(*
:[font = subsection; inactive; preserveAspect; startGroup]
Compute the Period of x^a mod n (Quantum Method)
:[font = input; initialization; preserveAspect; startGroup]
*)
Period[x_, n_, q_]:=
	Module[{reg1, reg2, measureReg2, projectReg1, fourierReg1,
	        samplesOfReg1, valuesOfReg1, r},
		  
		  reg1 = Apply[Plus, Map[(N[1/Sqrt[q]] ket[#])&, Range[0, q-1]]];
		  DescribeStep4[reg1];
		  DescribeStep5[reg1,q,n]; 
	
		reg2 = Map[Mod[x^#[[2,1]], n]&, Apply[List, reg1]];
		  DescribeStep6[reg1, reg2, q, n];
		
		measureReg2 = SampleRegister[reg2];
		  Print["Step 3(d): Measuring the state of Reg2"];
		  Print["measureReg2 = ", measureReg2];
		  DescribeStep7[reg1, reg2, q, n, measureReg2];
		  Print["The measurement of Reg2 has a side effect on the state of Reg1."];
		  Print["In fact the state of Reg1 is projected into:"];
		
		projectReg1 = Renormalize[Select[reg1, 
		                                 (Mod[x^#[[2,1]], n] == measureReg2)&]];
		  DescribeStep8[reg1, reg2, projectReg1, measureReg2, n];
	
	      Print["\n"];
	      Print["Step 3(e): Computing discrete Fourier transform of the contents of Reg1."];
	      Print["This may take several minutes!"];
	      Print["(Remember you are watching a classical simulation of a quantum algorithm)."];
		fourierReg1  = QuantumDFT[projectReg1, q] // Chop;
		  DescribeStep9[fourierReg1, measureReg2];
	
	 
	 	samplesOfReg1 = Table[SampleRegister1[fourierReg1], {12}];
	Print["\n"];
	Print["Steps 3(f)&3(g): Sample from Fourier spectrum created in Reg1"];
	Print["This entails repeating the previous steps & measuring Reg1 each time."];
	Print["Found samples: ", samplesOfReg1];
		valuesOfReg1 = DeleteCases[Sort[Union[Map[First, samplesOfReg1]]], 0];
		  DescribeStep10[fourierReg1, measureReg2, First[valuesOfReg1]];
		  DescribeStep11[fourierReg1, valuesOfReg1];
	Print["\nStep 4: Extract the period, r, from the given samples."];
		DescribeStep12[];
		r = ExtractPeriodFromContinuedFraction[valuesOfReg1, n, q]
]


NotAllIntegersQ[{}]:=True
NotAllIntegersQ[ans_]:=
	Not[Apply[And, Map[IntegerQ[#[[2]]]&, ans]]]
	

QuantumDFT[w_. ket[a_], q_]:=
	Apply[Plus, 
	      Map[(N[w/Sqrt[q] Exp[2 Pi I a #/q]] ket[#])&, Range[0,q-1]]]
	     
QuantumDFT[superposition_, q_]:=
	Map[QuantumDFT[#,q]&, Expand[superposition]]

Renormalize[superposition_]:=
	Expand[N[1/(Sqrt[Length[superposition]] Factor[superposition][[1]])] superposition]
	
SampleRegister1[superposition_]:=
	Module[{elems, probs},
		elems = Map[#[[2]]&, Apply[List, superposition]];
		probs = Map[Abs[#[[1]]]^2&, Apply[List, superposition]];
		BiasedSelect[elems, probs]
	]

SampleRegister[contentsOfRegister_]:=
	Module[{counts, elems, probs},
		{counts, elems} = Transpose[Frequencies[contentsOfRegister]];
		probs = N[counts/Apply[Plus, counts]];
		BiasedSelect[elems, probs]
	]
	
(*
:[font = message; inactive; preserveAspect; endGroup; endGroup]
General::spell1: Possible spelling error: new symbol name "counts"
     is similar to existing symbol "conts".
:[font = subsection; inactive; preserveAspect; startGroup]
Extract the Period from a Continued Fraction Expansion
:[font = input; initialization; preserveAspect; startGroup]
*)
Needs["NumberTheory`ContinuedFractions`"]

ExtractPeriodFromContinuedFraction[samplesOfReg1_, n_, q_]:=
	Module[{rValues, r},
	 rValues = Map[ExtractPeriodFromOneSample[#,n,q]&, samplesOfReg1];
		r = MajorityOpinion[rValues];
		r
	]
	
ExtractPeriodFromContinuedFraction::canCancel = 
	"The quotient c/r = `1`/`2` can cancel further";
	
ExtractPeriodFromOneSample[k_, n_, q_]:=
	Module[{f, cPrime, r},
		f = ClosestFractionTo[k/q, n, q];
		cPrime = Numerator[f];
		r = Denominator[f];
		If[GCD[cPrime, r]==1,
		   r, 
		   Message[ExtractPeriodFromContinuedFraction::canCancel, cPrime, r]
		  ]
	]
	
ClosestFractionTo[f_, n_, q_]:=
	Module[{cfs, approximations},
		cfs = Table[Normal[ContinuedFraction[f, i]], {i, 1, n}];
		approximations = Select[cfs, Denominator[#]<=n&];
		Last[approximations]
	]
	
(* Each time you approximate k/q by lambda/r you get a particular 
   fraction lambda/r. Unfortunately, if lambda (the multiple of
   the inverse period) happens to share a common factor with the
   period, r, then Mathematica will cancel the common factor between
   lambda and r, converting lambda/r into lambda1/r1 (r1<r). Hence 
   the estimated value for "r" (i.e. r1) will be too low. For this 
   reason we repeat the algorithm a few times to obtain enough 
   samples to be sure that we have guessed the correct period, r.
*)
MajorityOpinion[rValues_]:=
	Module[{freq},
		pairs = Frequencies[rValues];
		freq = Map[First, pairs];
		pos = Position[freq, Max[freq]][[1]];
		pairs[[pos]][[1,2]]
	]
(*
;[s]
3:0,0;1016,1;1027,0;1504,-1;
2:2,11,9,Courier,1,10,0,0,0;1,11,9,Courier,3,10,0,0,0;
:[font = message; inactive; preserveAspect; endGroup; endGroup]
General::spell1: Possible spelling error: new symbol name "cPrime"
     is similar to existing symbol "Prime".
:[font = subsection; inactive; preserveAspect; startGroup]
Utility: BiasedSelect
:[font = input; initialization; preserveAspect; startGroup]
*)
(* The list of probabilities should sum to 1. The call to Partition 
   constructs a set of probability intervals whose width is proportional
   to the probability with which the corresponding element in list 
   is selected.
*)
BiasedSelect[list_, probabilities_]:=
	Module[{random},
		random  = Random[];
		Apply[Part[list, #]&,
		      Flatten[
		       Position[Map[InRangeQ[random, #]&, 
		                    Partition[FoldList[Plus,0,probabilities],2,1]
		                   ],
		                True
		       ]
		      ]
		     ]
	] (* /;CheckProbabilitiesQ[probabilities] *)

BiasedSelect::usage =
	"BiasedSelect[{e1,e2,...,en}, {p1,p2,...,pn}] returns element ei of \
	the first list with probability given in the second list pi.";

BiasedSelect::probabilityLeak =
	"You have a probability leak. The probabilities you specified do \
	not add up to 1.";

BiasedSelect::excess =
	"The probabilities you specified sum to greater than 1.";

CheckProbabilitiesQ[probabilities_]:=
	Module[{psum = Apply[Plus, probabilities]},
		Which[psum<1,  Message[BiasedSelect::probabilityLeak],
		      psum>1,  Message[BiasedSelect::excess],
		      psum==1, True
		     ]
	]
	
InRangeQ[n_, {lb_, 1}]:=   lb <= n <= 1
InRangeQ[n_, {lb_, ub_}]:= lb <= n < ub
(*
:[font = message; inactive; preserveAspect; endGroup; endGroup]
General::spell1: Possible spelling error: new symbol name "random"
     is similar to existing symbol "Random".
:[font = subsection; inactive; preserveAspect; startGroup]
Computing the Period of x^a mod n (Classical Method)
:[font = text; inactive; preserveAspect]
This function is only used to provide a quick simulation of the input/output behavior of Shor's algorithm. It is a purely classical algorithm.
:[font = input; initialization; preserveAspect; startGroup]
*)
PeriodOfSequence[sequence_] := 
  Module[{period, chunks}, period = 1; 
    chunks = PartitionWithRmdr[sequence, period]; 
    While[ !PeriodicQ[chunks] && period <= Length[sequence], 
     period++; chunks = PartitionWithRmdr[sequence, period]]; 
    If[ !PeriodicQ[chunks], Infinity, period]]

PeriodicQ[{{___}}] := False
PeriodicQ[{firstLists__, lastList_}] := 
  Module[{firstList}, firstList = First[{firstLists}]; 
    {firstList} === Union[{firstLists}] && Subsequence[lastList, firstList]]

Subsequence[{list__}, {list__, ___}] := True
Subsequence[_, _] := False

PartitionWithRmdr[list_, size_] := 
  Module[{rmdr}, rmdr = {Take[list, -Mod[Length[list], size]]}; 
    Join[Partition[list, size], If[rmdr === {{}}, {}, rmdr]]]
(*
:[font = message; inactive; preserveAspect]
General::spell1: Possible spelling error: new symbol name "period"
     is similar to existing symbol "Period".
:[font = message; inactive; preserveAspect; endGroup]
General::spell1: Possible spelling error: new symbol name "firstList"
     is similar to existing symbol "firstLists".
:[font = input; initialization; preserveAspect; startGroup]
*)
(* This function computes the period of the sequence of
   values of x^a mod n directly. We use it simply to allow a
   fast (fake) simulation of Shor's quantum algorithm. In Shor's
   algorithm a quantum computer can compute the DFT very quickly.
   However, when we SIMULATE a quantum algorithm on a classical
   machine it appears to be much slower. Don't be fooled. The
   quantum algorithm for factoring an integer would, if run on a 
   quantum computer, be much more efficient than any classical 
   factoring algorithm, running on any classical computer. Indeed
   the inefficiency of simulating quantum computers on classical
   computers is inevitable. Otherwise you could achieve the same
   efficiency as a quantum computer simply by simulating a quantum
   computer on a classical machine. This is not so. There is no
   known way to simulate quantum physics on a classical machine
   without incurring an exponential slow down.
*)

PeriodViaClassicalAlgorithm[x_, n_, q_]:=
	Module[{reg1, reg2, lists, periods},
		reg1 = Apply[Plus, Map[(N[1/Sqrt[q]] ket[#])&, Range[0, q-1]]];
	Print["reg1 = ", Short[reg1, 8]]; 
		reg2 = Map[Mod[x^#[[2,1]], n]&, Apply[List, reg1]];
	Print["\nreg2 = ", reg2]; 
		PeriodOfSequence[reg2]
	]
	
AllSameQ[first_, rest_]:=
	Apply[And, Map[first === #&, rest]]
(*
:[font = message; inactive; preserveAspect]
General::spell1: Possible spelling error: new symbol name "lists"
     is similar to existing symbol "list".
:[font = message; inactive; preserveAspect; endGroup; endGroup]
General::spell1: Possible spelling error: new symbol name "periods"
     is similar to existing symbol "period".
:[font = subsection; inactive; preserveAspect; startGroup]
Code for creating graphics
:[font = input; preserveAspect]
Clear[PlotReg2VSReg1, PlotProbabilitiesVSContents]
:[font = input; preserveAspect; endGroup; endGroup]
PlotReg2VSReg1[reg1_, reg2_, opts___]:=
	ListPlot[MapThread[{#1, #2}&, {reg1, reg2}],
	         Frame->True,
	         GridLines->Automatic,
	         opts
	        ]
	
PlotProbabilitiesVSContents[w_. ket[i_] + kets_., opts___]:=
	Module[{probs, conts, grid, frame},
		probs = Probabilities[w ket[i] + kets];
		conts = Contents[w ket[i] + kets];
		ListPlot[MapThread[{#1, #2}&, {conts, probs}],
		         opts,
		         GridLines->Automatic,
		         Frame->True]
	]
		
(* w_. ket[i_] + kets_. is a superposition of states of a quantum
   memory register. Probabilities[...] gives the probability with
   which each result would be obtained upon measuring the state of
   the register. Contents[...] gives the actual values that are
   stored in superposition in the register.
*)
Probabilities[w_. ket[i_] + kets_.]:=
	Module[{amplitudes},
		amplitudes = Map[#[[1]]&, Apply[List, w ket[i] + kets]];
		Abs[amplitudes/Sqrt[Apply[Plus, Abs[amplitudes]^2]]]^2
	]

Probabilities[superposition_List]:=
	Probabilities[Apply[Plus, superposition]]

Contents[w_. ket[i_] + kets_.]:=
	Map[#[[2,1]]&, Apply[List, w ket[i] + kets]]

Contents[superposition_List]:=
	Contents[Apply[Plus, superposition]]
:[font = section; inactive; preserveAspect; startGroup]
Your Own Experiments Here ...
:[font = subsubsection; inactive; preserveAspect; startGroup]
Try me!
:[font = input; preserveAspect; startGroup]
RunShorsAlgorithm[16]
:[font = output; output; inactive; preserveAspect; endGroup; endGroup; endGroup; endGroup]
{8, 2}
;[o]
{8, 2}
^*)
